/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;

public class HQCKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int n;
    private int k;
    private int delta;
    private int w;
    private int wr;
    private int we;
    private int N_BYTE;
    private HQCKeyGenerationParameters hqcKeyGenerationParameters;
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters params) {
        this.hqcKeyGenerationParameters = (HQCKeyGenerationParameters)params;
        this.random = params.getRandom();
        this.n = this.hqcKeyGenerationParameters.getParameters().getN();
        this.k = this.hqcKeyGenerationParameters.getParameters().getK();
        this.delta = this.hqcKeyGenerationParameters.getParameters().getDelta();
        this.w = this.hqcKeyGenerationParameters.getParameters().getW();
        this.wr = this.hqcKeyGenerationParameters.getParameters().getWr();
        this.we = this.hqcKeyGenerationParameters.getParameters().getWe();
        this.N_BYTE = (this.n + 7) / 8;
    }

    private AsymmetricCipherKeyPair genKeyPair(byte[] seed) {
        HQCEngine engine = this.hqcKeyGenerationParameters.getParameters().getEngine();
        byte[] pk = new byte[40 + this.N_BYTE];
        byte[] sk = new byte[80 + this.N_BYTE];
        engine.genKeyPair(pk, sk, seed);
        HQCPublicKeyParameters publicKey = new HQCPublicKeyParameters(this.hqcKeyGenerationParameters.getParameters(), pk);
        HQCPrivateKeyParameters privateKey = new HQCPrivateKeyParameters(this.hqcKeyGenerationParameters.getParameters(), sk);
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] seed = new byte[48];
        this.random.nextBytes(seed);
        return this.genKeyPair(seed);
    }

    public AsymmetricCipherKeyPair generateKeyPairWithSeed(byte[] seed) {
        return this.genKeyPair(seed);
    }
}

