/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.info;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.savignano.cryptography.info.InfoData;

public class InfoDataManager {
    private List<Consumer<InfoData>> consumers;

    public void register(Consumer<InfoData> consumer) {
        if (this.consumers == null) {
            this.consumers = new ArrayList<Consumer<InfoData>>(1);
        }
        this.consumers.add(consumer);
    }

    public void unregister(Consumer<InfoData> consumer) {
        if (this.consumers != null) {
            this.consumers.remove(consumer);
            if (this.consumers.isEmpty()) {
                this.consumers = null;
            }
        }
    }

    public void send(InfoData data) {
        if (data != null && this.consumers != null) {
            for (Consumer<InfoData> consumer : this.consumers) {
                consumer.accept(data);
            }
        }
    }
}

