/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PgpKeyServerLoader
extends AKeyLoader<PgpEncryptionKey, String> {
    public static final int INFO_NO_LOCATION = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_KEYSERVER_CONNECTED = 202;
    public static final int INFO_KEYSERVER_DISCONNECTED = 203;
    public static final int INFO_KEYSERVER_CONNECTION_ERROR = 204;
    public static final int INFO_KEYSERVER_RESPONSE = 205;
    public static final int INFO_EMAIL_FOUND = 206;
    public static final int INFO_EMAIL_NOT_FOUND = 207;
    public static final int INFO_WRONG_CONTENT_TYPE = 208;
    public static final int INFO_WRONG_CONTENT = 209;
    private static final String HEADER_FIELD_LOCATION = "Location";
    private final String keyServer;
    private boolean encodeSearchParam = true;
    private int timeout = 20000;

    public PgpKeyServerLoader(String keyServer) {
        this.keyServer = keyServer;
    }

    @Override
    protected PgpEncryptionKey loadInternalKey(String email) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.keyServer)) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Location must not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)email)) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be empty.");
        }
        Logger log = this.getLog();
        log.info("Looking up public key for email <{}> from: {}", (Object)email, (Object)this.keyServer);
        Set<String> keyIds = this.getKeyIdsFromServer(this.keyServer, "<" + email.toLowerCase(Locale.ROOT) + ">");
        if (keyIds.isEmpty()) {
            log.debug("No public key found for: <{}>", (Object)email);
            this.getInfoDataManager().send(new InfoData(207, email));
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Key IDs found for <{}>: {}", (Object)email, keyIds);
        this.getInfoDataManager().send(new InfoData(206, email));
        List<PgpEncryptionKey> keys = this.getKeysFromServer(this.keyServer, keyIds, email);
        PgpEncryptionKey key = this.getNewestKey(keys);
        if (key.getKeyValidity() == EKeyValidity.VALID) {
            log.info("Found public key for email <{}> with ID: {}", (Object)email, (Object)PgpUtil.getPrettyId(key.getMasterKey()));
        } else {
            log.info("No public key found for email: <{}>", (Object)email);
        }
        return key;
    }

    private Set<String> getKeyIdsFromServer(String baseUrl, String searchFor) throws IOException {
        this.getLog().debug("Looking up public key for {} from: {}", (Object)searchFor, (Object)baseUrl);
        URL url = this.createUrl(baseUrl, searchFor, "index", this.isEncodeSearchParam());
        return this.getKeyIdsFromServer(url, searchFor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKeyIdsFromServer(URL url, String searchFor) throws IOException {
        Set<String> keyIds;
        block11: {
            HttpURLConnection connection;
            block12: {
                Logger log = this.getLog();
                boolean connected = false;
                connection = null;
                try {
                    connection = this.createConnection(url);
                    log.debug("Connecting to: {}", (Object)connection.getURL());
                    connection.connect();
                    connected = true;
                    this.getInfoDataManager().send(new InfoData(202, url.toString()));
                    int responseCode = connection.getResponseCode();
                    String responseMessage = connection.getResponseMessage();
                    log.debug("Response code for key server {} : {} ({})", new Object[]{url.getHost(), responseCode, responseMessage});
                    if (responseCode == 200) {
                        log.debug("Found public key(s) for: {}", (Object)searchFor);
                        this.getInfoDataManager().send(new InfoData(205, url.getHost(), responseCode, responseMessage));
                        keyIds = this.getKeyIdsFromServer(connection, searchFor);
                    } else if (responseCode >= 300 && responseCode < 400 && connection.getHeaderField(HEADER_FIELD_LOCATION) != null) {
                        String newLocation = connection.getHeaderField(HEADER_FIELD_LOCATION);
                        log.debug("Response code {} received. Redirect to new location: {}", (Object)responseCode, (Object)newLocation);
                        this.getInfoDataManager().send(new InfoData(205, newLocation, responseCode, responseMessage));
                        keyIds = this.getKeyIdsFromServer(new URL(newLocation), searchFor);
                    } else if (responseCode == 404) {
                        log.debug("No public key found for: {}", (Object)searchFor);
                        this.getInfoDataManager().send(new InfoData(205, url.getHost(), responseCode, responseMessage));
                        keyIds = Collections.emptySet();
                    } else {
                        log.error("Connecting to key server \"{}\" not successful. Server returned response code {}: {}", new Object[]{url, responseCode, responseMessage});
                        if (log.isDebugEnabled()) {
                            log.debug("Headers: {}", connection.getHeaderFields());
                        }
                        this.getInfoDataManager().send(new InfoData(205, url.getHost(), responseCode, responseMessage));
                        keyIds = Collections.emptySet();
                    }
                    if (connection == null) break block11;
                    if (!connected) break block12;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        if (connected) {
                            this.getInfoDataManager().send(new InfoData(203, url.toString()));
                        }
                        connection.disconnect();
                    }
                    throw throwable;
                }
                this.getInfoDataManager().send(new InfoData(203, url.toString()));
            }
            connection.disconnect();
        }
        return keyIds;
    }

    private Set<String> getKeyIdsFromServer(HttpURLConnection connection, String searchFor) throws IOException {
        Logger log = this.getLog();
        HashSet<String> keyIds = new HashSet<String>();
        String contentType = null;
        boolean contentTypeCorrect = false;
        boolean contentCorrect = false;
        try (InputStream is = connection.getInputStream();){
            contentType = connection.getContentType();
            log.debug("Received content type: {}", (Object)contentType);
            if (contentType != null && contentType.startsWith("text/plain")) {
                contentTypeCorrect = true;
                long currentTime = System.currentTimeMillis() / 1000L;
                String keyId = null;
                boolean skipToNextKey = false;
                String encoding = connection.getContentEncoding();
                LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));
                while (lineIterator.hasNext()) {
                    String[] parts;
                    String line = URLDecoder.decode(lineIterator.nextLine(), "UTF-8").toLowerCase(Locale.ROOT);
                    log.trace(line);
                    if (line.startsWith("pub:")) {
                        contentCorrect = true;
                        skipToNextKey = true;
                        keyId = null;
                        parts = line.split(":", 7);
                        if (parts.length != 7) continue;
                        keyId = parts[1];
                        String expirationDate = parts[5];
                        String flags = parts[6];
                        boolean validKey = flags.isEmpty() || expirationDate.isEmpty() || Long.parseLong(expirationDate) > currentTime;
                        skipToNextKey = !validKey;
                        continue;
                    }
                    if (skipToNextKey || !line.startsWith("uid:")) continue;
                    contentCorrect = true;
                    parts = line.split(":", 5);
                    if (parts.length != 5 || !parts[1].contains(searchFor)) continue;
                    log.info("Found matching public key for {} with ID: {}", (Object)searchFor, (Object)keyId);
                    keyIds.add(keyId);
                }
            }
        }
        if (!contentTypeCorrect) {
            log.error("Wrong content type received. Expected \"text/plain\", but was: {}", (Object)contentType);
            this.getInfoDataManager().send(new InfoData(208, contentType));
        } else if (!contentCorrect) {
            log.error("Wrong content received. Server probably not an HKP server.");
            this.getInfoDataManager().send(new InfoData(209, new Object[0]));
        }
        return keyIds;
    }

    private List<PgpEncryptionKey> getKeysFromServer(String baseUrl, Collection<String> keyIds, String email) {
        ArrayList<PgpEncryptionKey> keys = new ArrayList<PgpEncryptionKey>(keyIds.size());
        for (String keyId : keyIds) {
            PGPPublicKeyRing key = null;
            try {
                key = this.getKeyFromServer(baseUrl, keyId);
            }
            catch (IOException e) {
                this.getLog().warn("Error retrieving public key with ID " + keyId + " from keyserver for email: <" + email + ">", (Throwable)e);
            }
            if (key == null) continue;
            PgpEncryptionKey pgpKey = new PgpEncryptionKey(key, email);
            pgpKey.setKeySource(this.getKeySource());
            keys.add(pgpKey);
        }
        return keys;
    }

    private PGPPublicKeyRing getKeyFromServer(String baseUrl, String keyId) throws IOException {
        this.getLog().debug("Looking up pulic key with ID: " + keyId);
        URL url = this.createUrl(baseUrl, "0x" + keyId, "get", false);
        return this.getKeyFromServer(url, keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGPPublicKeyRing getKeyFromServer(URL url, String keyId) throws IOException {
        PGPPublicKeyRing keyRing;
        block22: {
            Logger log = this.getLog();
            HttpURLConnection connection = null;
            try {
                connection = this.createConnection(url);
                log.debug("Connecting to: {}", (Object)connection.getURL());
                connection.connect();
                int responseCode = connection.getResponseCode();
                String responseMessage = connection.getResponseMessage();
                log.debug("Response code for key server {} : {} ({})", new Object[]{url.getHost(), responseCode, responseMessage});
                if (responseCode >= 200 && responseCode < 300) {
                    log.debug("Found public key for key ID: {}", (Object)keyId);
                    try (InputStream is = connection.getInputStream();){
                        keyRing = PgpUtil.loadPublicKey(is);
                        break block22;
                    }
                }
                if (responseCode >= 300 && responseCode < 400 && connection.getHeaderField(HEADER_FIELD_LOCATION) != null) {
                    String newLocation = connection.getHeaderField(HEADER_FIELD_LOCATION);
                    log.debug("Redirect to new location: {}", (Object)newLocation);
                    keyRing = this.getKeyFromServer(new URL(newLocation), keyId);
                } else if (responseCode == 404) {
                    log.debug("No public key found for key ID: {}", (Object)keyId);
                    keyRing = null;
                } else {
                    log.error("Could not retrieve key with key ID {} from key server \"{}\". Server returned response code {}: {}", new Object[]{keyId, url, responseCode, responseMessage});
                    if (log.isDebugEnabled()) {
                        log.debug("Headers: {}", connection.getHeaderFields());
                    }
                    keyRing = null;
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return keyRing;
    }

    private PgpEncryptionKey getNewestKey(Collection<PgpEncryptionKey> keys) {
        EKeyValidity fallbackValidity = EKeyValidity.ERROR;
        long newestCreationTime = 0L;
        PgpEncryptionKey newestKey = null;
        for (PgpEncryptionKey key : keys) {
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                PGPPublicKey encKey = key.getKey();
                if (encKey.getCreationTime().getTime() <= newestCreationTime) continue;
                newestCreationTime = encKey.getCreationTime().getTime();
                newestKey = key;
                continue;
            }
            fallbackValidity = key.getKeyValidity();
        }
        if (newestKey != null && this.getLog().isDebugEnabled()) {
            PGPPublicKey encKey = newestKey.getKey();
            PGPPublicKey masterKey = newestKey.getMasterKey();
            String prettyEncKeyId = PgpUtil.getPrettyId(encKey);
            String prettyMasterKeyId = PgpUtil.getPrettyId(masterKey);
            this.getLog().debug("Most current key (ID: {}, Master Key ID: {}). Creation time: {}", new Object[]{prettyEncKeyId, prettyMasterKeyId, encKey.getCreationTime()});
        } else if (newestKey == null) {
            this.getLog().debug("Could not find a valid key. Most likely explanation: {}", (Object)fallbackValidity);
            newestKey = this.getValidityKey(fallbackValidity);
        }
        return newestKey;
    }

    protected URL createUrl(String baseUrl, String searchFor, String operation, boolean encode) throws UnsupportedEncodingException, MalformedURLException {
        String basePath = "pks/lookup";
        String searchArg = "search";
        String operationArg = "op";
        String options = "options=mr";
        String exact = "exact=on";
        StringBuilder builder = new StringBuilder(1000);
        boolean hkpFound = baseUrl.startsWith("hkp");
        if (hkpFound) {
            hkpFound = true;
            builder.append("http");
            builder.append(baseUrl.substring(3));
        } else {
            builder.append(baseUrl);
        }
        if (baseUrl.charAt(baseUrl.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append("pks/lookup");
        builder.append('?');
        builder.append("options=mr");
        builder.append('&');
        builder.append("exact=on");
        builder.append('&');
        builder.append("op");
        builder.append('=');
        builder.append(operation);
        builder.append('&');
        builder.append("search");
        builder.append('=');
        builder.append(encode ? URLEncoder.encode(searchFor, "UTF-8") : searchFor);
        URL url = new URL(builder.toString());
        if (hkpFound && url.getPort() == -1) {
            int port = url.getProtocol().equals("http") ? 11371 : 443;
            return new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        }
        return url;
    }

    private HttpURLConnection createConnection(URL url) throws IOException {
        this.getLog().debug("Creating connection for URL: {}", (Object)url);
        URLConnection con = url.openConnection();
        if (!(con instanceof HttpURLConnection)) {
            IOException e = new IOException("URL does not create a HTTP connection.");
            this.getInfoDataManager().send(new InfoData(204, url.toString(), e));
            throw e;
        }
        HttpURLConnection connection = (HttpURLConnection)con;
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(false);
        connection.setConnectTimeout(this.getTimeout());
        connection.setReadTimeout(this.getTimeout());
        return connection;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSERVER;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, this.getKeySource());
    }

    public String getKeyServerUrl() {
        return this.keyServer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isEncodeSearchParam() {
        return this.encodeSearchParam;
    }

    public void setEncodeSearchParam(boolean encodeSearchParam) {
        this.encodeSearchParam = encodeSearchParam;
    }

    public String toString() {
        return "PgpKeyServerLoader [keyServer=" + this.keyServer + ", encodeSearchParam=" + this.encodeSearchParam + ", timeout=" + this.timeout + "]";
    }
}

