/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common;

import java.util.Optional;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;

public enum EProperty {
    GUI_KEY(EPropertyType.GLOBAL, "gui.key", String.class, null),
    GUI_VERSION(EPropertyType.GLOBAL, "gui.version", String.class, null),
    MAILER_VERSION(EPropertyType.GLOBAL, "mailer.version", String.class, null),
    PUBLIC_KEYSERVER_PGP_LOCATION(EPropertyType.GLOBAL, "pgp.keyserverLocation", String.class, null),
    PUBLIC_KEYSTORE_PGP_TYPE(EPropertyType.GLOBAL, "pgp.keystoreType", String.class, "KEYRING"),
    PUBLIC_KEYSTORE_PGP_LOCATION(EPropertyType.GLOBAL, "pgp.keystoreLocation", String.class, null),
    PUBLIC_KEYSTORE_SMIME_LOCATION(EPropertyType.GLOBAL, "smime.keystoreLocation", String.class, null),
    PUBLIC_KEYSTORE_SMIME_TYPE(EPropertyType.GLOBAL, "smime.keystoreType", String.class, "PKCS7"),
    PRIVATE_SMIME_KEYSTORE_LOCATION(EPropertyType.GLOBAL, "smime.private.keystoreLocation", String.class, null),
    PRIVATE_SMIME_KEY_PASSWORD(EPropertyType.GLOBAL, "smime.private.keyPassword", char[].class, null),
    PRIVATE_PGP_KEYSTORE_LOCATION(EPropertyType.GLOBAL, "pgp.private.keystoreLocation", String.class, null),
    PRIVATE_PGP_KEY_PASSWORD(EPropertyType.GLOBAL, "pgp.private.keyPassword", char[].class, null),
    USER_DIRECTORY_LDAP_QUERY_SMIME(EPropertyType.GLOBAL, "ldap.smime.query", Boolean.class, false),
    PUBLIC_LDAP_HOST_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.host", String.class, null),
    PUBLIC_LDAP_PORT_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.port", Long.class, 389L),
    PUBLIC_LDAP_SSL_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.ssl", Boolean.class, false),
    PUBLIC_LDAP_DN_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.dn", String.class, null),
    PUBLIC_LDAP_LOGIN_USER_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.login.user", String.class, null),
    PUBLIC_LDAP_LOGIN_PASSWORD_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.login.password", char[].class, null),
    PUBLIC_LDAP_FILTER_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.fitler", String.class, null),
    PUBLIC_LDAP_MAILATTR_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.mailattr", String.class, "mail"),
    PUBLIC_LDAP_REFERRAL_SMIME(EPropertyType.GLOBAL, "ldap.smime.public.referral", String.class, "ignore"),
    EXPIRE_KEYS_PUBLIC_TIMESTAMP(EPropertyType.GLOBAL, "mailer.expireKeys.timeStamp", Long.class, null),
    EXPIRE_KEYS_PRIVATE_TIMESTAMP(EPropertyType.GLOBAL, "mailer.expireKeys.private.timeStamp", Long.class, null),
    ENCRYPTION_TYPE_PRIORITY(EPropertyType.GLOBAL, "mailer.encryptionTypePriority", EEncryptionTypePriority.class, (Object)((Object)EEncryptionTypePriority.SMIME_PREFERRED)),
    ENCRYPTION_FAILURE_BEHAVIOR(EPropertyType.GLOBAL, "mailer.encryptionFailureBehavior", EEncryptionFailureBehavior.class, (Object)((Object)EEncryptionFailureBehavior.ALLOW)),
    REPORT_MESSAGE_SHOW_LINK(EPropertyType.GLOBAL, "mailer.reportMessage.showLink", Boolean.class, false),
    ALLOW_PASSWORD_RESET_MAIL(EPropertyType.GLOBAL, "mailer.passwordResetMail.unencrypted", Boolean.class, false),
    FREEZE_SNOTIFY(EPropertyType.GLOBAL, "mailer.freeze", Boolean.class, false),
    DISABLE_SNOTIFY(EPropertyType.GLOBAL, "mailer.disable", Boolean.class, false),
    DEV_MODE(EPropertyType.GLOBAL, "dev.mode", Boolean.class, false),
    LITE_MODE(EPropertyType.GLOBAL, "lite.mode", Boolean.class, false),
    ALLOW_PGP_PUBLIC_KEY_OVERWRITE(EPropertyType.GLOBAL, "pgp.key.allowUserOverwrite", Boolean.class, true),
    ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE(EPropertyType.GLOBAL, "pgp.key.allowJsdUserOverwrite", Boolean.class, false),
    ALLOW_SMIME_CERTIFICATE_OVERWRITE(EPropertyType.GLOBAL, "smime.cert.allowUserOverwrite", Boolean.class, true),
    ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE(EPropertyType.GLOBAL, "smime.cert.allowJsdUserOverwrite", Boolean.class, false),
    SUBJECT_PROTECTION(EPropertyType.GLOBAL, "mailer.encryption.subjectProtection", Boolean.class, false),
    SUBJECT_PROTECTION_KEEP_ID(EPropertyType.GLOBAL, "mailer.encryption.subjectProtectionKeepId", Boolean.class, false),
    DECORATE_RECEIVED_MAILS(EPropertyType.GLOBAL, "mailer.received.decorate", Boolean.class, false),
    SIGNING_ENABLED(EPropertyType.GLOBAL, "mailer.sign.enabled", Boolean.class, true),
    SIGNING_SMIME_OPAQUE(EPropertyType.GLOBAL, "mailer.sign.smime.opaque", Boolean.class, false),
    REMOVE_SIGNATURES(EPropertyType.GLOBAL, "mailer.signature.remove", Boolean.class, true),
    EXTRACT_PUBLIC_KEY_FROM_SIGNATURES(EPropertyType.GLOBAL, "pgp.signature.extractPublicKey", Boolean.class, false),
    EXTRACT_CERTIFICATE_FROM_SIGNATURES(EPropertyType.GLOBAL, "smime.signature.extractPublicKey", Boolean.class, false),
    WHITELIST_USER_GROUP(EPropertyType.GLOBAL, "mailer.whitelist.usergroup", String.class, null),
    ENABLE_PROJECT_SPECIFIC_ENCRYPTION(EPropertyType.GLOBAL, "project.enableSpecificEncryption", Boolean.class, false),
    DEFAULT_PROJECT_ENCRYPTION_STATE(EPropertyType.GLOBAL, "project.defaultEncryptionState", Boolean.class, true),
    AMBIGUOUS_PROJECT_ENCRYPTION_STATE(EPropertyType.GLOBAL, "project.ambiguousEncryptionState", Boolean.class, true),
    NO_PROJECT_ENCRYPTION_STATE(EPropertyType.GLOBAL, "project.noEncryptionState", Boolean.class, true),
    EMAIL_SMIME_CERT(EPropertyType.USER, "email.smime.cert", byte[].class, null),
    EMAIL_SMIME_TIME_STAMP(EPropertyType.USER, "email.smime.timeStamp", Long.class, null),
    EMAIL_SMIME_KEY_SOURCE(EPropertyType.USER, "email.smime.keySource", EKeySource.class, (Object)((Object)EKeySource.UNKNOWN)),
    EMAIL_PGP_KEY(EPropertyType.USER, "email.pgp.key", byte[].class, null),
    EMAIL_PGP_KEY_ID(EPropertyType.USER, "email.pgp.key.id", Long.class, null),
    EMAIL_PGP_TIME_STAMP(EPropertyType.USER, "email.pgp.timeStamp", Long.class, null),
    EMAIL_PGP_KEY_SOURCE(EPropertyType.USER, "email.pgp.keySource", EKeySource.class, (Object)((Object)EKeySource.UNKNOWN)),
    PROJECT_ENABLE_ENCRYPTION(EPropertyType.PROJECT, "project.enableEncryption", Boolean.class, false),
    TWEAK_OVERVIEW(EPropertyType.GLOBAL, "tweak.overview", String.class, null),
    TWEAK_DO_NOT_ENCODE_PGP_SEARCH_PARAMETER(EPropertyType.GLOBAL, "tweak.doNotEncodePgpSearchParam", Boolean.class, false),
    TWEAK_URL_CONNECTION_TIMEOUT(EPropertyType.GLOBAL, "tweak.urlConnectionTimeoutDuringMailing", Long.class, 20000L),
    TWEAK_DRY_RUN_MAILER(EPropertyType.GLOBAL, "tweak.dryRunMailer", Boolean.class, false),
    TWEAK_EXPECT_P7B_IN_LDAP(EPropertyType.GLOBAL, "tweak.expectP7bInLdap", Boolean.class, false),
    TWEAK_SMIME_OPAQUE_SIGN(EPropertyType.GLOBAL, "tweak.smimeOpaqueSign", Boolean.class, false),
    TWEAK_SMIME_ADDITIONAL_SIGN(EPropertyType.GLOBAL, "tweak.smimeAdditionalSign", Boolean.class, false),
    TWEAK_SMIME_IGNORE_CERT_PATH_VALIDATION(EPropertyType.GLOBAL, "tweak.smimeIgnoreCertPathValidation", Boolean.class, false),
    TWEAK_SMIME_STRICT_CERTIFICATE_CHECKING(EPropertyType.GLOBAL, "tweak.smimeStrictCertificateChecking", Boolean.class, false),
    TWEAK_SMIME_DOMAIN_CERTIFICATE(EPropertyType.GLOBAL, "tweak.smimeDomainCertificates", String.class, null),
    TWEAK_PGP_ADDITIONAL_SIGN(EPropertyType.GLOBAL, "tweak.pgpAdditionalSign", Boolean.class, false),
    TWEAK_PGP_INLINE_SUPPORT(EPropertyType.GLOBAL, "tweak.pgpInlineSupport", Boolean.class, false),
    TWEAK_PGP_BINARY_REGEX(EPropertyType.GLOBAL, "tweak.pgpBinaryRegex", String.class, null),
    TWEAK_SKIP_ENCRYPTION_REGEX(EPropertyType.GLOBAL, "tweak.skipEncryptionRegex", String.class, null),
    TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT(EPropertyType.GLOBAL, "tweak.reportAdditionalText", String.class, null),
    TWEAK_REPORT_MESSAGE_REPLACE_TEXT(EPropertyType.GLOBAL, "tweak.reportReplaceText", String.class, null),
    TWEAK_REPORT_MESSAGE_DOMAIN_BLOCK_TEXT(EPropertyType.GLOBAL, "tweak.blockDomainReportText", String.class, null),
    TWEAK_DOMAIN_BLOCK_EMAILS(EPropertyType.GLOBAL, "tweak.blockDomainList", String.class, null),
    TWEAK_PGP_SYMMETRIC_KEY_ALGORITHM(EPropertyType.GLOBAL, "tweak.pgpSymmetricCipher", Long.class, null),
    TWEAK_PGP_PREFERRED_CIPHERS_ONLY(EPropertyType.GLOBAL, "tweak.pgpPreferredCiphersOnly", Boolean.class, false),
    TWEAK_RECEIVED_MAILS_EXTENDED_DECORATION(EPropertyType.GLOBAL, "tweak.incomingMailExtendedDecoration", Boolean.class, false),
    TWEAK_CERTIFICATION_REVOCATION_ENABLED(EPropertyType.GLOBAL, "tweak.smimeCertificateCrlCheck", Boolean.class, false),
    TWEAK_SIGN_BASE64_ENCODED(EPropertyType.GLOBAL, "tweak.signBase64Encoded", Boolean.class, false),
    TWEAK_SUBJECT_PROTECTION_REPLACEMENT(EPropertyType.GLOBAL, "tweak.subjectProtectionReplacement", String.class, null),
    TWEAK_SUBJECT_PROTECTION_METHOD(EPropertyType.GLOBAL, "tweak.subjectProtectionMethod", String.class, "protected-headers-v1"),
    TWEAK_LDAP_CONTEXT_REFERRAL(EPropertyType.GLOBAL, "tweak.ldapContextReferral", String.class, null),
    TWEAK_USER_DIRECTORY_INSECURE(EPropertyType.GLOBAL, "tweak.allowUserDirectoryInsecureSSL", Boolean.class, false),
    TWEAK_EXTERNAL_LDAP_INSECURE(EPropertyType.GLOBAL, "tweak.allowExternalLdapInsecureSSL", Boolean.class, false);

    private static final String PREFIX = "net.savignano.snotify.";
    private final EPropertyType propType;
    private final String key;
    private final Class<?> type;
    private final Object defValue;

    public static final Optional<EProperty> getProperty(String key) {
        if (key == null) {
            return Optional.empty();
        }
        String k = key.startsWith(PREFIX) ? key : PREFIX + key;
        for (EProperty prop : EProperty.values()) {
            if (!prop.getKey().equals(k)) continue;
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    private EProperty(EPropertyType propType, String key, Class<?> type, Object defValue) {
        this.propType = propType;
        this.key = PREFIX + key;
        this.type = type;
        this.defValue = defValue;
        if (propType == null) {
            throw new IllegalStateException("Property Type must not be null.");
        }
        if (key == null) {
            throw new IllegalStateException("Key must not be null.");
        }
        if (type == null) {
            throw new IllegalStateException("Type must not be null.");
        }
        if (defValue != null && !type.isAssignableFrom(defValue.getClass())) {
            throw new IllegalStateException("\"" + defValue + "\" (" + defValue.getClass().getCanonicalName() + ") is not assignable as default value. Value is expected to be of class: " + type.getCanonicalName());
        }
        if (defValue == null && (type.isEnum() || type == Boolean.class)) {
            throw new IllegalStateException("Default value must not be null for this class type.");
        }
    }

    public EPropertyType getPropType() {
        return this.propType;
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defValue;
    }

    public static enum EPropertyType {
        GLOBAL,
        USER,
        PROJECT;

    }
}

