/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import jakarta.mail.Address;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUser
implements IUser<User> {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceUser.class);
    private final User user;

    public static final Optional<ConfluenceUser> lookupUser(Address address) {
        return ConfluenceUser.lookupUser(MessageUtil.getEmail(address));
    }

    public static final Optional<ConfluenceUser> lookupUser(String email) {
        List<ConfluenceUser> users = ConfluenceUser.lookupUsers(email);
        switch (users.size()) {
            case 0: {
                log.info("No user found for email: {}", (Object)email);
                return Optional.empty();
            }
            case 1: {
                return Optional.of(users.get(0));
            }
        }
        log.warn("Multiple users found for email {}. First user found is used, but this can be unpredictable: {}", (Object)email, users);
        return Optional.of(users.get(0));
    }

    public static final List<ConfluenceUser> lookupUsers(Address address) {
        return ConfluenceUser.lookupUsers(MessageUtil.getEmail(address));
    }

    public static final List<ConfluenceUser> lookupUsers(String email) {
        List users;
        if (email == null) {
            return Collections.emptyList();
        }
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        DisabledUserManager disabledUserManager = (DisabledUserManager)ComponentLocator.getComponent(DisabledUserManager.class);
        try {
            log.trace("Looking up users for email: {}", (Object)email);
            users = userAccessor.findUsersAsList((Query)new EmailTermQuery(email));
            log.trace("Found users: {}", (Object)users);
        }
        catch (EntityException e) {
            log.error("Could not get users for email <" + email + ">. Error message: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        List<ConfluenceUser> list = users.stream().filter(user -> !disabledUserManager.isDisabled(user)).map(ConfluenceUser::new).collect(Collectors.toList());
        log.debug("Found users for email <{}>: {}", (Object)email, list);
        return list;
    }

    public ConfluenceUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        this.user = user;
    }

    @Override
    public String getDisplayName() {
        return this.user.getFullName();
    }

    @Override
    public String getEmail() {
        return this.user.getEmail();
    }

    @Override
    public User getActualUser() {
        return this.user;
    }

    public com.atlassian.confluence.user.ConfluenceUser getAsConfluenceUser() {
        User actualUser = this.getActualUser();
        if (actualUser == null) {
            return null;
        }
        if (actualUser instanceof com.atlassian.confluence.user.ConfluenceUser) {
            com.atlassian.confluence.user.ConfluenceUser confUser = (com.atlassian.confluence.user.ConfluenceUser)actualUser;
            return confUser;
        }
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        return userAccessor.getUserByName(actualUser.getName());
    }

    public String toString() {
        return this.user.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfluenceUser other = (ConfluenceUser)obj;
        return !(this.user == null ? other.user != null : !this.user.equals((Object)other.user));
    }
}

