/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.extractor;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailPageTitleExtractor
extends AAtlassianMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailPageTitleExtractor.class);

    public ConfluenceMailPageTitleExtractor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getKey(URL url) {
        return this.getKeyDisplayVersion(url);
    }

    private String getKeyDisplayVersion(URL url) {
        String path = url.getPath();
        String indicator = "/display/";
        return this.getKey(path, "/display/");
    }

    private String getKey(String path, String indicator) {
        String lastPart;
        int lastIndex;
        if (path.indexOf(indicator) != -1 && (lastIndex = path.lastIndexOf(47)) != -1 && !(lastPart = path.substring(lastIndex + 1)).isEmpty() && lastPart.charAt(0) != '~') {
            try {
                return URLDecoder.decode(lastPart, StandardCharsets.ISO_8859_1.name());
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

