/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.util.Option;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LicenseListener {
    private static final Logger log = LoggerFactory.getLogger(LicenseListener.class);
    @Inject
    @ComponentImport
    private EventPublisher publisher;
    @Inject
    @ComponentImport
    private PluginLicenseEventRegistry pluginPublisher;
    @Inject
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @Inject
    @ComponentImport
    private BandanaManager settings;

    @PostConstruct
    public void init() {
        this.publisher.register((Object)this);
        this.pluginPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.publisher.unregister((Object)this);
        this.pluginPublisher.unregister((Object)this);
    }

    private boolean isRelevant(PluginEvent event) {
        return this.isRelevant(event.getPlugin().getKey());
    }

    private boolean isRelevant(String pluginKey) {
        return this.licenseManager.getPluginKey().equalsIgnoreCase(pluginKey);
    }

    @EventListener
    public void refresh(PluginRefreshedEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Refreshed Event for S/Notify detected: {}", (Object)event);
            this.checkLicense();
        }
    }

    @EventListener
    public void enabled(PluginEnabledEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Enabled Event for S/Notify detected: {}", (Object)event);
            this.setDisablement(false);
            this.checkLicense();
        }
    }

    @EventListener
    public void disabled(PluginDisablingEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Disabling Event for S/Notify detected: {}", (Object)event);
            this.setDisablement(true);
        }
    }

    @EventListener
    public void startup(PluginFrameworkStartedEvent event) {
        log.debug("Plugin Framework Start Event for S/Notify detected: {}", (Object)event);
        this.checkLicense();
    }

    @EventListener
    public void license(PluginLicenseEvent event) {
        if (this.isRelevant(event.getPluginKey())) {
            log.debug("Plugin License Event for S/Notify detected: {}", (Object)event);
            this.checkLicense();
        }
    }

    private void setDisablement(boolean disable) {
        boolean oldDisabled;
        Boolean oldDisabledValue = (Boolean)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.mailer.disable");
        boolean bl = oldDisabled = oldDisabledValue != null && oldDisabledValue != false;
        if (oldDisabled != disable) {
            if (disable) {
                log.info("Disabling S/Notify mailer.");
            } else {
                log.info("Enabling S/Notify mailer.");
            }
            this.settings.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.mailer.disable", (Object)disable);
        }
    }

    private void checkLicense() {
        boolean oldFreeze;
        this.printLicense();
        boolean freeze = this.freezeSnotify();
        Boolean oldFreezeValue = (Boolean)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.mailer.freeze");
        boolean bl = oldFreeze = oldFreezeValue != null && oldFreezeValue != false;
        if (oldFreeze != freeze) {
            if (freeze) {
                log.info("S/Notify mailer was frozen because of an invalid license.");
            } else {
                log.info("S/Notify mailer was restored. Proper license found.");
            }
            this.settings.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.mailer.freeze", (Object)freeze);
        }
    }

    private boolean freezeSnotify() {
        Option licenseOption = this.licenseManager.getLicense();
        if (licenseOption.isDefined()) {
            PluginLicense license = (PluginLicense)licenseOption.get();
            return !license.isValid() && license.isEvaluation();
        }
        return true;
    }

    private void printLicense() {
        Option option = this.licenseManager.getLicense();
        if (option.isDefined()) {
            PluginLicense license = (PluginLicense)option.get();
            log.debug("S/Notify license: {}", (Object)license);
            if (license.getError().isDefined()) {
                LicenseError licenseError = (LicenseError)license.getError().get();
                log.debug("S/Notify license error: {}", (Object)licenseError);
            }
        } else {
            log.debug("No license for S/Notify defined.");
        }
    }
}

