/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyGlobalSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -3639412912780907286L;
    private static final String HIDDEN = "hidden";
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private static final String ENCRYPTION_FAILURE_PARAM = "encryptionFailure";
    private static final String UPDATE_PARAM = "update";
    private static final Logger log = LoggerFactory.getLogger(SnotifyGlobalSettingsAction.class);
    private final BandanaManager settings = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        return "input";
    }

    public String doSubmit() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String encryptionFailure = this.getCurrentRequest().getParameter(ENCRYPTION_FAILURE_PARAM);
        this.setStringValue("net.savignano.snotify.email.encryptionFailure", encryptionFailure);
        return "success";
    }

    public String getChecked(String id, boolean defaultChecked) {
        String prop = this.getStringValue("net.savignano.snotify.email.encryptionFailure");
        boolean checked = prop == null ? defaultChecked : prop.equalsIgnoreCase(id);
        return checked ? CHECKBOX_CHECKED : "";
    }

    public String getHideUpdateInfo() {
        String updateParam = this.getCurrentRequest().getParameter(UPDATE_PARAM);
        boolean update = Boolean.parseBoolean(updateParam);
        return update ? "" : HIDDEN;
    }

    private void setStringValue(String key, String value) {
        this.settings.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key, (Object)value);
    }

    private String getStringValue(String key) {
        return (String)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
    }
}

