/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import net.savignano.snotify.confluence.gui.Mailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyKeystoreSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -3672832928332627619L;
    private static final String HIDDEN = "hidden";
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private static final String PRIORITY_PARAM = "priority";
    private static final String LOCATION_PARAM = "keystore";
    private static final String PASSWORD_PARAM = "password";
    private static final String UPDATE_PARAM = "update";
    private static final String VERIFY_BUTTON_PARAM = "Verify";
    private static final Logger log = LoggerFactory.getLogger(SnotifyKeystoreSettingsAction.class);
    private final BandanaManager settings = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    private String location;
    private String password;
    private String priority;
    private String verifyErrorMessage;
    private boolean showVerified;

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        if (this.location == null) {
            this.readProps();
        }
        return "input";
    }

    public String doSubmit() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.readParams();
        if (this.getCurrentRequest().getParameter(VERIFY_BUTTON_PARAM) != null) {
            return this.verifySettings();
        }
        return this.storeSettings();
    }

    private String storeSettings() {
        this.storeProps();
        return "success";
    }

    private String verifySettings() {
        I18NBean i18n = this.getI18n();
        String errorMessage = null;
        if (this.location == null || this.location.isEmpty()) {
            errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.emptyLocation");
        } else {
            try {
                this.loadKeyStore(this.location, null);
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keystore", new Object[]{e.getLocalizedMessage()});
                log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
            }
            catch (CertificateException e) {
                errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.certificate", new Object[]{e.getLocalizedMessage()});
                log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                boolean properLocation = false;
                try {
                    properLocation = new File(this.location).canRead();
                }
                catch (SecurityException e1) {
                    log.info("Can not access keystore location: " + this.location, (Throwable)e1);
                }
                errorMessage = properLocation || e.getCause() instanceof UnrecoverableKeyException ? i18n.getText("snotify-keystore-settings-webwork.input.error.password") : i18n.getText("snotify-keystore-settings-webwork.input.error.location", new Object[]{e.getLocalizedMessage()});
                log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        this.verifyErrorMessage = errorMessage;
        this.showVerified = this.verifyErrorMessage == null;
        return "input";
    }

    private KeyStore loadKeyStore(String location, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Provider provider = Mailer.getProvider();
        KeyStore ks = KeyStore.getInstance("BKS", provider);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            ks.load(in, password == null ? null : password.toCharArray());
        }
        return ks;
    }

    public String getHideUpdateInfo() {
        String updateParam = this.getCurrentRequest().getParameter(UPDATE_PARAM);
        boolean update = Boolean.parseBoolean(updateParam);
        return update ? "" : HIDDEN;
    }

    public String getHideVerifyInfo() {
        return this.showVerified ? "" : HIDDEN;
    }

    public String getHideVerifyError() {
        return this.getVerificationErrorMessage().isEmpty() ? HIDDEN : "";
    }

    @HtmlSafe
    public String getVerificationErrorMessage() {
        return this.verifyErrorMessage == null ? "" : this.verifyErrorMessage;
    }

    public String getKeystoreLocation() {
        return this.location == null ? "" : this.location;
    }

    public String getKeystorePassword() {
        return this.password == null ? "" : this.password;
    }

    public String getChecked(String id, boolean defaultChecked) {
        boolean checked = this.priority == null || this.priority.isEmpty() ? defaultChecked : this.priority.equalsIgnoreCase(id);
        return checked ? CHECKBOX_CHECKED : "";
    }

    private void readParams() {
        this.location = this.getCurrentRequest().getParameter(LOCATION_PARAM);
        this.priority = this.getCurrentRequest().getParameter(PRIORITY_PARAM);
    }

    private void storeProps() {
        this.settings.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.certificate.keystoreLocation", (Object)this.location);
        this.settings.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.certificate.locationPriority", (Object)this.priority);
    }

    private void readProps() {
        this.location = (String)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.certificate.keystoreLocation");
        this.password = (String)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.certificate.keystorePassword");
        this.priority = (String)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "net.savignano.snotify.certificate.locationPriority");
    }
}

