/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Mailer {
    private static final String PREFIX_PROP = "net.savignano.snotify.";
    public static final String EMAIL_CERT_PROP = "net.savignano.snotify.email.smime.cert";
    public static final String EMAIL_ENCRYPTION_FAILURE_PROP = "net.savignano.snotify.email.encryptionFailure";
    public static final String KEYSTORE_LOCATION_PROP = "net.savignano.snotify.certificate.keystoreLocation";
    public static final String KEYSTORE_PASSWORD_PROP = "net.savignano.snotify.certificate.keystorePassword";
    public static final String CERTIFICATE_LOCATION_PRIORITY_PROP = "net.savignano.snotify.certificate.locationPriority";
    public static final String FREEZE_SNOTIFY_PROP = "net.savignano.snotify.mailer.freeze";
    public static final String DISABLE_SNOTIFY_PROP = "net.savignano.snotify.mailer.disable";
    public static final String BOUNCY_CASTLE_KEYSTORE_TYPE = "BKS";
    public static final String X509_FACTORY_KEY = "X.509";
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";

    public static final Provider getProvider() {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            provider = new BouncyCastleProvider();
            Security.addProvider(provider);
        }
        return provider;
    }

    public static final String loadString(UserPreferences prefs, String key) {
        if (prefs == null || key == null) {
            return null;
        }
        if (!prefs.getBoolean(key + SETTINGS_STRING_EXISTS)) {
            return null;
        }
        int pages = (int)prefs.getLong(key + SETTINGS_STRING_PAGES);
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = prefs.getString(key + SETTINGS_STRING_PAGE + i);
            builder.append(page);
        }
        return builder.toString();
    }

    public static final void storeString(UserPreferences prefs, String key, String value) throws AtlassianCoreException {
        if (prefs == null || key == null) {
            return;
        }
        Mailer.removeString(prefs, key);
        if (value != null) {
            int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
            if (pages > 0) {
                for (int i = 0; i < pages - 1; ++i) {
                    prefs.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255));
                }
                prefs.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255));
            }
            prefs.setLong(key + SETTINGS_STRING_PAGES, (long)pages);
            prefs.setBoolean(key + SETTINGS_STRING_EXISTS, true);
        }
    }

    private static final void removeString(UserPreferences prefs, String key) throws AtlassianCoreException {
        if (!prefs.getBoolean(key + SETTINGS_STRING_EXISTS)) {
            return;
        }
        int pages = (int)prefs.getLong(key + SETTINGS_STRING_PAGES);
        prefs.remove(key + SETTINGS_STRING_EXISTS);
        prefs.remove(key + SETTINGS_STRING_PAGES);
        for (int i = 0; i < pages; ++i) {
            prefs.remove(key + SETTINGS_STRING_PAGE + i);
        }
    }
}

