/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.html.encode.HtmlEncoder;
import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import net.savignano.snotify.confluence.gui.Mailer;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyUserSettingsAction
extends AbstractUserProfileAction {
    private static final long serialVersionUID = -5462548019091147432L;
    private static final String ERROR_EMAIL_MISMATCH = "error-email";
    private static final String ERROR_EXPIRED = "error-expired";
    private static final String ERROR_NOTYETVALID = "error-notyetvalid";
    private static final String CERT_FILE_PARAM = "cert-file";
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserSettingsAction.class);
    private Exception lastException;

    public String doInput() {
        ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        return "input";
    }

    public String doSubmit() {
        ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        MultiPartRequestWrapper requestWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        if (requestWrapper.hasErrors()) {
            Collection errors = requestWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                this.addActionError((String)i.next());
            }
            return "error";
        }
        File certFile = null;
        File[] files = requestWrapper.getFiles(CERT_FILE_PARAM);
        if (files != null && files.length > 0) {
            certFile = files[0];
        }
        try {
            byte[] cert = certFile != null ? Files.readAllBytes(certFile.toPath()) : null;
            this.setEmailCert(cert, user);
            return "success";
        }
        catch (EmailException e) {
            this.lastException = e;
            log.info("Email address mismatch.", (Throwable)e);
            return ERROR_EMAIL_MISMATCH;
        }
        catch (CertificateExpiredException e) {
            this.lastException = e;
            log.info("Certificate expired.", (Throwable)e);
            return ERROR_EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            this.lastException = e;
            log.info("Certificate not yet valid.", (Throwable)e);
            return ERROR_NOTYETVALID;
        }
        catch (CertificateException e) {
            this.lastException = e;
            log.info("Certificate parsing failed.", (Throwable)e);
            return "error";
        }
        catch (IOException e) {
            this.lastException = e;
            log.info("Certificate upload failed.", (Throwable)e);
            return "error";
        }
        catch (AtlassianCoreException e) {
            this.lastException = e;
            log.info("Storing certificate in user preferences failed.", (Throwable)e);
            return "error";
        }
    }

    private void setEmailCert(byte[] cert, ConfluenceUser user) throws CertificateException, AtlassianCoreException {
        ConfluenceUserPreferences userPrefs = this.userAccessor.getConfluenceUserPreferences((User)user);
        if (cert == null || cert.length == 0) {
            log.debug("Clearing certificate for user: " + user.getFullName());
            Mailer.storeString(userPrefs.getWrappedPreferences(), "net.savignano.snotify.email.smime.cert", null);
        } else {
            log.debug("Checking certificate for user: " + user.getFullName());
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
            certificate.checkValidity();
            JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(certificate);
            String certEmail = this.getRDNValue(certHolder.getSubject(), BCStyle.E);
            if (certEmail == null || !certEmail.equalsIgnoreCase(user.getEmail())) {
                throw new EmailException(certEmail, user.getFullName());
            }
            log.debug("Setting certificate for user: " + user.getFullName());
            Mailer.storeString(userPrefs.getWrappedPreferences(), "net.savignano.snotify.email.smime.cert", new String(Base64.encodeBase64((byte[])cert)));
        }
    }

    private String buildCertInfo(byte[] cert) throws CertificateException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
        JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(certificate);
        X500Name issuer = certHolder.getIssuer();
        X500Name subject = certHolder.getSubject();
        StringBuilder builder = new StringBuilder(500);
        this.buildEntry(builder, this.getDefaultResourceBundle().getString("snotify-user-settings-item.input.cert.valid"), certificate.getNotBefore(), "cert-valid");
        this.buildEntry(builder, this.getDefaultResourceBundle().getString("snotify-user-settings-item.input.cert.expires"), certificate.getNotAfter(), "cert-expires");
        this.buildEntry(builder, this.getDefaultResourceBundle().getString("snotify-user-settings-item.input.cert.for"), this.getRDNValue(subject, BCStyle.CN) + " (" + this.getRDNValue(subject, BCStyle.E) + ")", "cert-subject");
        this.buildEntry(builder, this.getDefaultResourceBundle().getString("snotify-user-settings-item.input.cert.issuer"), this.getRDNValue(issuer, BCStyle.CN) + " (" + this.getRDNValue(issuer, BCStyle.E) + ")", "cert-issuer");
        this.buildEntry(builder, this.getDefaultResourceBundle().getString("snotify-user-settings-item.input.cert.algorithm"), certificate.getSigAlgName(), "cert-algorithm");
        return builder.toString();
    }

    private String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = name.getRDNs(identifier);
        if (rdns.length == 0) {
            return null;
        }
        return rdns[0].getFirst().getValue().toString();
    }

    private void buildEntry(StringBuilder builder, String label, Object value, String id) {
        builder.append("<tr>");
        if (id == null) {
            builder.append("<th align=\"right\">");
        } else {
            builder.append("<th align=\"right\" id=\"");
            builder.append(HtmlEncoder.encode((String)id));
            builder.append("\">");
        }
        builder.append(HtmlEncoder.encode((String)label));
        builder.append(":</th><td>");
        if (value == null) {
            builder.append("N/A");
        } else {
            builder.append(HtmlEncoder.encode((String)value.toString()));
        }
        builder.append("</td></tr>\n");
    }

    public String getErrorMessage() {
        return this.lastException == null ? null : this.lastException.getMessage();
    }

    @HtmlSafe
    public String getCertDetails() {
        ConfluenceUser profileUser = this.getUser();
        ConfluenceUserPreferences userPrefs = this.userAccessor.getConfluenceUserPreferences((User)profileUser);
        String info = null;
        byte[] cert = null;
        try {
            String base64Cert = Mailer.loadString(userPrefs.getWrappedPreferences(), "net.savignano.snotify.email.smime.cert");
            if (base64Cert != null && !base64Cert.isEmpty()) {
                cert = Base64.decodeBase64((byte[])base64Cert.getBytes(Mailer.UTF8_CHARSET));
            }
        }
        catch (PropertyException e) {
            log.error("Could not load user property net.savignano.snotify.email.smime.cert for user " + profileUser.getFullName() + ".", (Throwable)e);
            info = this.getText("email-security.settings.error", new String[]{e.getLocalizedMessage()});
        }
        if (cert == null && info == null) {
            info = this.getText("email-security.settings.notfound");
            log.debug("No certificate specified for user: {}", (Object)profileUser.getFullName());
        } else if (cert != null) {
            try {
                info = this.buildCertInfo(cert);
                log.debug("Certificate information for user {}: {}", (Object)profileUser.getFullName(), (Object)info);
            }
            catch (CertificateException e) {
                log.error("Could not load public certificate for user: " + profileUser.getFullName(), (Throwable)e);
                info = this.getText("email-security.settings.error", new String[]{e.getLocalizedMessage()});
            }
        }
        return info;
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = -5262905856665194L;

        private EmailException(String email, String user) {
            super("Email address of certificate (" + email + ") does not match email of user: " + user);
        }
    }
}

