/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import net.savignano.snotify.confluence.gui.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyGlobalSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -3639412912780907286L;
    private static final String HIDDEN = "hidden";
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private static final String ENCRYPTION_FAILURE_PARAM = "encryptionFailure";
    private static final String ENCRYPTION_TYPE_PRIORITY_PARAM = "encryptionTypePriority";
    private static final String UPDATE_PARAM = "update";
    private static final Logger log = LoggerFactory.getLogger(SnotifyGlobalSettingsAction.class);

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        return "input";
    }

    public String doSubmit() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String encryptionFailure = this.getCurrentRequest().getParameter(ENCRYPTION_FAILURE_PARAM);
        this.setStringValue("net.savignano.snotify.mailer.encryptionFailureBehavior", encryptionFailure);
        String encryptionTypePriority = this.getCurrentRequest().getParameter(ENCRYPTION_TYPE_PRIORITY_PARAM);
        this.setStringValue("net.savignano.snotify.mailer.encryptionTypePriority", encryptionTypePriority);
        return "success";
    }

    public String getCheckedPriority(String id, boolean defaultChecked) {
        String prop = this.getStringValue("net.savignano.snotify.mailer.encryptionTypePriority");
        boolean checked = prop == null ? defaultChecked : prop.equalsIgnoreCase(id);
        return checked ? CHECKBOX_CHECKED : "";
    }

    public String getCheckedFailure(String id, boolean defaultChecked) {
        String prop = this.getStringValue("net.savignano.snotify.mailer.encryptionFailureBehavior");
        boolean checked = prop == null ? defaultChecked : prop.equalsIgnoreCase(id);
        return checked ? CHECKBOX_CHECKED : "";
    }

    public String getHideUpdateInfo() {
        String updateParam = this.getCurrentRequest().getParameter(UPDATE_PARAM);
        boolean update = Boolean.parseBoolean(updateParam);
        return update ? "" : HIDDEN;
    }

    private void setStringValue(String key, String value) {
        PropertiesUtil.getAppProps().setString(key, value);
    }

    private String getStringValue(String key) {
        return PropertiesUtil.getAppProps().getString(key);
    }
}

