/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import net.savignano.snotify.confluence.gui.Mailer;
import net.savignano.snotify.confluence.gui.PropertiesUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyKeystoreSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -3672832928332627619L;
    private static final String HIDDEN = "hidden";
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private static final String KEYSTORE_LOCATION_PARAM = "keystore";
    private static final String KEYSERVER_LOCATION_PARAM = "keyserver";
    private static final String EXPIRE_KEYS_PARAM = "expireKeys";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PARAM = "allowPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_PARAM = "allowSmimeCertOverwrite";
    private static final String UPDATE_PARAM = "update";
    private static final String VERIFY_BUTTON_PARAM = "Test settings";
    private static final Logger log = LoggerFactory.getLogger(SnotifyKeystoreSettingsAction.class);
    private String keyserverLocation;
    private String keystoreLocation;
    private String verifyErrorMessage;
    private boolean expireKeys;
    private boolean allowSmimeOverwrite;
    private boolean allowPgpOverwrite;
    private boolean showVerified;

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        if (this.keystoreLocation == null) {
            this.readProps();
        }
        return "input";
    }

    public String doSubmit() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.readParams();
        if (this.getCurrentRequest().getParameter(VERIFY_BUTTON_PARAM) != null) {
            return this.verifySettings();
        }
        return this.storeSettings();
    }

    private String storeSettings() {
        this.storeProps();
        return "success";
    }

    private String verifySettings() {
        String secondErrorMessage;
        I18NBean i18n = this.getI18n();
        String errorMessage = null;
        if (this.keystoreLocation != null && !this.keystoreLocation.isEmpty()) {
            errorMessage = this.verifyKeystore(i18n);
        }
        if (this.keyserverLocation != null && !this.keyserverLocation.isEmpty() && (secondErrorMessage = this.verifyKeyserver(i18n)) != null) {
            errorMessage = errorMessage == null ? secondErrorMessage : errorMessage + "<br>" + secondErrorMessage;
        }
        this.verifyErrorMessage = errorMessage;
        this.showVerified = this.verifyErrorMessage == null;
        return "input";
    }

    private String verifyKeystore(I18NBean i18n) {
        String errorMessage = null;
        try {
            this.loadKeyStore(this.keystoreLocation, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keystore", new Object[]{e.getLocalizedMessage()});
            log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keystore.certificate", new Object[]{e.getLocalizedMessage()});
            log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            boolean properLocation = false;
            try {
                properLocation = new File(this.keystoreLocation).canRead();
            }
            catch (SecurityException e1) {
                log.info("Can not access keystore location: " + this.keystoreLocation, (Throwable)e1);
            }
            errorMessage = e.getCause() instanceof UnrecoverableKeyException || properLocation ? i18n.getText("snotify-keystore-settings-webwork.input.error.keystore.password") : i18n.getText("snotify-keystore-settings-webwork.input.error.keystore.location", new Object[]{e.getLocalizedMessage()});
            log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifyKeyserver(I18NBean i18n) {
        String errorMessage = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(this.keyserverLocation);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                log.info("Error during verification of keystore. Response code of server: {}", (Object)connection.getResponseCode());
                errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keyserver.connect", new Object[]{i18n.getText("snotify-keystore-settings-webwork.input.error.keyserver.code", new Object[]{connection.getResponseCode()})});
            }
        }
        catch (ClassCastException e) {
            log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
            errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keyserver.http");
        }
        catch (MalformedURLException e) {
            log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
            errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keyserver.url", new Object[]{e.getLocalizedMessage()});
        }
        catch (IOException e) {
            log.info("Error during verification of keystore. Error message: " + e.getMessage(), (Throwable)e);
            errorMessage = i18n.getText("snotify-keystore-settings-webwork.input.error.keyserver.connect", new Object[]{e.getLocalizedMessage()});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return errorMessage;
    }

    private KeyStore loadKeyStore(String location, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Provider provider = Mailer.getProvider();
        KeyStore ks = KeyStore.getInstance("BKS", provider);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            ks.load(in, password == null ? null : password.toCharArray());
        }
        return ks;
    }

    public String getCheckedSmimeOverwrite() {
        return this.allowSmimeOverwrite ? CHECKBOX_CHECKED : "";
    }

    public String getCheckedPgpOverwrite() {
        return this.allowPgpOverwrite ? CHECKBOX_CHECKED : "";
    }

    public String getHideUpdateInfo() {
        String updateParam = this.getCurrentRequest().getParameter(UPDATE_PARAM);
        boolean update = Boolean.parseBoolean(updateParam);
        return update ? "" : HIDDEN;
    }

    public String getHideVerifyInfo() {
        return this.showVerified ? "" : HIDDEN;
    }

    public String getHideVerifyError() {
        return this.getVerificationErrorMessage().isEmpty() ? HIDDEN : "";
    }

    @HtmlSafe
    public String getVerificationErrorMessage() {
        return this.verifyErrorMessage == null ? "" : this.verifyErrorMessage;
    }

    public String getKeyserverLocation() {
        return this.keyserverLocation == null ? "" : this.keyserverLocation;
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation == null ? "" : this.keystoreLocation;
    }

    private void readParams() {
        this.keyserverLocation = this.getCurrentRequest().getParameter(KEYSERVER_LOCATION_PARAM);
        this.keystoreLocation = this.getCurrentRequest().getParameter(KEYSTORE_LOCATION_PARAM);
        this.expireKeys = Boolean.parseBoolean(this.getCurrentRequest().getParameter(EXPIRE_KEYS_PARAM));
        this.allowSmimeOverwrite = Boolean.parseBoolean(this.getCurrentRequest().getParameter(ALLOW_SMIME_CERTIFICATE_OVERWRITE_PARAM));
        this.allowPgpOverwrite = Boolean.parseBoolean(this.getCurrentRequest().getParameter(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PARAM));
    }

    private void storeProps() {
        boolean locationChanged = this.isLocationChanged();
        PropertiesUtil.getAppProps().setString("net.savignano.snotify.pgp.keyserverLocation", this.keyserverLocation);
        PropertiesUtil.getAppProps().setString("net.savignano.snotify.smime.keystoreLocation", this.keystoreLocation);
        PropertiesUtil.getAppProps().setBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", this.allowSmimeOverwrite);
        PropertiesUtil.getAppProps().setBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", this.allowPgpOverwrite);
        if (this.expireKeys || locationChanged) {
            PropertiesUtil.getAppProps().setLong("net.savignano.snotify.mailer.expireKeys.timeStamp", System.currentTimeMillis());
        }
    }

    private void readProps() {
        this.keyserverLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.pgp.keyserverLocation");
        this.keystoreLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.smime.keystoreLocation");
        this.allowSmimeOverwrite = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        this.allowPgpOverwrite = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
    }

    private boolean isLocationChanged() {
        String oldKeystoreLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.smime.keystoreLocation");
        String oldKeyserverLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.pgp.keyserverLocation");
        if (!StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldKeystoreLocation), (String)StringUtils.stripToNull((String)this.keystoreLocation))) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldKeyserverLocation), (String)StringUtils.stripToNull((String)this.keyserverLocation));
    }
}

