/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X962Parameters;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECPoint;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.MPInteger;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPPad;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.RFC6637Utils;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        super(key);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pubKey, byte[] sessionInfo) throws PGPException {
        try {
            if (pubKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                X9ECParameters x9Params = JcaJcePGPUtil.getX9Parameters(ecKey.getCurveOID());
                AlgorithmParameters ecAlgParams = this.helper.createAlgorithmParameters("EC");
                ecAlgParams.init(new X962Parameters(ecKey.getCurveOID()).getEncoded());
                KeyPairGenerator kpGen = this.helper.createKeyPairGenerator("EC");
                kpGen.initialize(ecAlgParams.getParameterSpec(AlgorithmParameterSpec.class));
                KeyPair ephKP = kpGen.generateKeyPair();
                KeyAgreement agreement = this.helper.createKeyAgreement(RFC6637Utils.getAgreementAlgorithm(pubKey.getPublicKeyPacket()));
                agreement.init((Key)ephKP.getPrivate(), new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(pubKey.getPublicKeyPacket(), new JcaKeyFingerprintCalculator())));
                agreement.doPhase(this.keyConverter.getPublicKey(pubKey), true);
                SecretKey key = agreement.generateSecret(RFC6637Utils.getKeyEncryptionOID(ecKey.getSymmetricKeyAlgorithm()).getId());
                Cipher c = this.helper.createKeyWrapper(ecKey.getSymmetricKeyAlgorithm());
                c.init(3, (Key)key, this.random);
                byte[] paddedSessionData = PGPPad.padSessionData(sessionInfo);
                byte[] C = c.wrap(new SecretKeySpec(paddedSessionData, PGPUtil.getSymmetricCipherName(sessionInfo[0])));
                SubjectPublicKeyInfo epPubKey = SubjectPublicKeyInfo.getInstance(ephKP.getPublic().getEncoded());
                X9ECPoint derQ = new X9ECPoint(x9Params.getCurve(), epPubKey.getPublicKeyData().getBytes());
                ECPoint publicPoint = derQ.getPoint();
                byte[] VB = new MPInteger(new BigInteger(1, publicPoint.getEncoded(false))).getEncoded();
                byte[] rv = new byte[VB.length + 1 + C.length];
                System.arraycopy(VB, 0, rv, 0, VB.length);
                rv[VB.length] = (byte)C.length;
                System.arraycopy(C, 0, rv, VB.length + 1, C.length);
                return rv;
            }
            Cipher c = this.helper.createPublicKeyCipher(pubKey.getAlgorithm());
            PublicKey key = this.keyConverter.getPublicKey(pubKey);
            c.init(1, (Key)key, this.random);
            return c.doFinal(sessionInfo);
        }
        catch (IllegalBlockSizeException e) {
            throw new PGPException("illegal block size: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new PGPException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("key invalid: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PGPException("unable to encode MPI: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("unable to set up ephemeral keys: " + e.getMessage(), e);
        }
    }
}

