/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openssl;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMDecryptorProvider;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMException;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMKeyPairParser;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String dekAlgName, byte[] iv, byte[] keyBytes, PEMKeyPairParser parser) {
        this.dekAlgName = dekAlgName;
        this.iv = iv;
        this.keyBytes = keyBytes;
        this.parser = parser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider keyDecryptorProvider) throws IOException {
        try {
            PEMDecryptor keyDecryptor = keyDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(keyDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException e) {
            throw e;
        }
        catch (OperatorCreationException e) {
            throw new PEMException("cannot create extraction operator: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PEMException("exception processing key pair: " + e.getMessage(), e);
        }
    }
}

