/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPgpKey {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPgpKey.class);
    private final PGPPublicKeyRing ring;
    private final PGPPublicKey masterKey;
    private PGPPublicKey encryptionKey;

    public SnotifyPgpKey(PGPPublicKeyRingCollection collection, String email) throws KeyException {
        if (collection == null) {
            throw new IllegalArgumentException("Key ring collection must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email address must not be null.");
        }
        log.debug("Looking up key ring for email {}.", (Object)email);
        PGPPublicKeyRing matchedRing = null;
        Iterator<PGPPublicKeyRing> iterRing = collection.iterator();
        block0: while (iterRing.hasNext() && matchedRing == null) {
            PGPPublicKeyRing ring = iterRing.next();
            for (PGPPublicKey key : ring) {
                if (!key.isMasterKey()) continue;
                long keyId = key.getKeyID();
                String prettyKeyId = Long.toHexString(keyId).toUpperCase();
                Iterator<String> iter = key.getUserIDs();
                while (iter.hasNext()) {
                    if (!iter.next().toLowerCase().contains(email)) continue;
                    log.debug("Master key (ID: {}) is valid for email {}.", (Object)prettyKeyId, (Object)email);
                    matchedRing = ring;
                    break;
                }
                if (matchedRing != null || !log.isDebugEnabled()) continue block0;
                ArrayList<String> ids = new ArrayList<String>();
                Iterator<String> iter2 = key.getUserIDs();
                while (iter2.hasNext()) {
                    ids.add(iter2.next());
                }
                if (ids.isEmpty()) {
                    log.debug("Key with ID {} does not contain any user IDs.", (Object)prettyKeyId);
                    continue block0;
                }
                log.debug("Key with ID {} had the following user IDs: {}", (Object)prettyKeyId, ids);
                continue block0;
            }
        }
        if (matchedRing == null) {
            throw new KeyManagementException("No matching PGP public key found for email adress: " + email);
        }
        this.ring = matchedRing;
        this.masterKey = this.findMasterKey();
    }

    public SnotifyPgpKey(PGPPublicKeyRing ring) {
        if (ring == null) {
            throw new IllegalArgumentException("Key ring must not be null.");
        }
        this.ring = ring;
        this.masterKey = this.findMasterKey();
    }

    private PGPPublicKey findMasterKey() {
        for (PGPPublicKey key : this.ring) {
            if (!key.isMasterKey()) continue;
            log.debug("Master key ID: {}", (Object)Long.toHexString(key.getKeyID()).toUpperCase());
            return key;
        }
        throw new IllegalStateException("No master key found in public ring.");
    }

    public PGPPublicKey getMasterKey() {
        return this.masterKey;
    }

    public PGPPublicKey getEncryptionKey() {
        if (this.encryptionKey != null) {
            return this.encryptionKey;
        }
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        for (PGPPublicKey key : this.ring) {
            if (!this.isValidEncryptionKey(key)) continue;
            keys.add(key);
        }
        PGPPublicKey newestKey = null;
        for (PGPPublicKey key : keys) {
            if (newestKey != null && !newestKey.getCreationTime().before(key.getCreationTime())) continue;
            newestKey = key;
        }
        if (log.isDebugEnabled()) {
            if (newestKey == null) {
                log.debug("No key found that can be used for encryption. Master key ID: {}", (Object)Long.toHexString(this.getMasterKey().getKeyID()).toUpperCase());
            } else {
                log.debug("Using key with ID {}. Creation time: {}", (Object)Long.toHexString(newestKey.getKeyID()).toUpperCase(), (Object)newestKey.getCreationTime());
            }
        }
        this.encryptionKey = newestKey;
        return newestKey;
    }

    private boolean isValidEncryptionKey(PGPPublicKey key) {
        boolean valid;
        long keyId = key.getKeyID();
        String prettyKeyId = Long.toHexString(keyId).toUpperCase();
        if (!key.isEncryptionKey()) {
            log.debug("Algorithm for key with ID {} can not be used for encryption.", (Object)prettyKeyId);
            return false;
        }
        boolean keyFlagsUsed = false;
        boolean encryptionFlag = false;
        Iterator signatures = key.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
            if (packets == null) continue;
            int keyFlags = packets.getKeyFlags();
            boolean bl = keyFlagsUsed = keyFlagsUsed || keyFlags != 0;
            if ((keyFlags & 4) == 0) continue;
            encryptionFlag = true;
            break;
        }
        if (!encryptionFlag && keyFlagsUsed) {
            log.debug("Key with ID {} has not the necessary flags for an encryption key.", (Object)prettyKeyId);
            return false;
        }
        if (key.hasRevocation()) {
            log.debug("Key with ID {} has been revoked.", (Object)prettyKeyId);
            return false;
        }
        long validSeconds = key.getValidSeconds();
        boolean bl = valid = validSeconds == 0L || validSeconds * 1000L + key.getCreationTime().getTime() >= System.currentTimeMillis();
        if (!valid) {
            log.debug("Key with ID {} is no loger valid. Expired: {}", (Object)prettyKeyId, (Object)new Date(validSeconds * 1000L + key.getCreationTime().getTime()));
            return false;
        }
        log.debug("Key with ID {} can be used for encryption.", (Object)prettyKeyId);
        return true;
    }

    public PGPPublicKey getKey(long keyId) {
        return this.ring.getPublicKey(keyId);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        this.ring.encode(baos, true);
        return baos.toByteArray();
    }
}

