/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.math.ec.custom.gm;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECFieldElement;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECLookupTable;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.math.ec.custom.gm.SM2P256V1FieldElement;
import net.savignano.thirdparty.org.bouncycastle.math.ec.custom.gm.SM2P256V1Point;
import net.savignano.thirdparty.org.bouncycastle.math.raw.Nat256;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

public class SM2P256V1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF"));
    private static final int SM2P256V1_DEFAULT_COORDS = 2;
    protected SM2P256V1Point infinity = new SM2P256V1Point(this, null, null);

    public SM2P256V1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SM2P256V1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SM2P256V1FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SM2P256V1Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SM2P256V1Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_INTS = 8;
        final int[] table = new int[len * 8 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat256.copy(((SM2P256V1FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat256.copy(((SM2P256V1FieldElement)p.getRawYCoord()).x, 0, table, pos += 8);
            pos += 8;
        }
        return new ECLookupTable(){

            public int getSize() {
                return len;
            }

            public ECPoint lookup(int index) {
                int[] x = Nat256.create();
                int[] y = Nat256.create();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    int MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 8; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 8 + j] & MASK;
                    }
                    pos += 16;
                }
                return SM2P256V1Curve.this.createRawPoint(new SM2P256V1FieldElement(x), new SM2P256V1FieldElement(y), false);
            }
        };
    }
}

