/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.keysource.verification;

import com.atlassian.confluence.util.i18n.I18NBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import net.savignano.snotify.confluence.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.confluence.gui.keysource.verification.IKeySourceVerification;
import net.savignano.snotify.confluence.gui.keysource.verification.VerificationStatus;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyServerVerification
implements IKeySourceVerification {
    private static final String VERIFY_KEYSERVER_FILE_PART = "/pks/lookup?op=index&options=mr&exact=on&search=";
    private static final Logger log = LoggerFactory.getLogger(PgpKeyServerVerification.class);
    private final I18NBean i18n;
    private final String location;
    private String email;

    public PgpKeyServerVerification(String location, I18NBean i18n) {
        this.location = location;
        this.i18n = i18n;
    }

    @Override
    public List<VerificationStatus> verify() {
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        this.emailPresent(statusList);
        return statusList;
    }

    private void emailPresent(List<VerificationStatus> statusList) {
        if (StringUtils.isBlank((String)this.email)) {
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = this.i18n.getText("pgp-keyserver-verification.emailPresent.failure.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.emailPresent.failure.message", new Object[]{this.location});
            statusList.add(status);
        } else {
            this.validateKeyServerUrl(statusList);
        }
    }

    private void validateKeyServerUrl(List<VerificationStatus> statusList) {
        log.debug("Verifying PGP key server location: {}", (Object)this.location);
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        try {
            URL url = this.createKeyServerUrl();
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("pgp-keyserver-verification.validUrl.success.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.validUrl.success.message", new Object[]{this.location});
            this.checkConnection(statusList, url);
        }
        catch (MalformedURLException e) {
            log.warn("Key server location is not a valid URL: " + this.location, (Throwable)e);
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("pgp-keyserver-verification.validUrl.exception.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.validUrl.excpetion.message", new Object[]{this.location});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection(List<VerificationStatus> statusList, URL url) {
        log.debug("Verification of PGP key server. Used URL: {}", (Object)url);
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(15000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            log.debug("Response code for key server {} : {} ({})", new Object[]{this.location, responseCode, connection.getResponseMessage()});
            if (responseCode >= 200 && responseCode < 300) {
                status.status = EVerificationStatus.SUCCESS;
                status.title = this.i18n.getText("pgp-keyserver-verification.connect.success.title");
                status.message = this.i18n.getText("pgp-keyserver-verification.connect.success.message", new Object[]{url});
                this.checkResponseForEmail(statusList, connection);
            } else if (responseCode == 404) {
                status.status = EVerificationStatus.SUCCESS;
                status.title = this.i18n.getText("pgp-keyserver-verification.connect.success.title");
                status.message = this.i18n.getText("pgp-keyserver-verification.connect.success.message", new Object[]{url});
                VerificationStatus additionalStatus = new VerificationStatus();
                additionalStatus.status = EVerificationStatus.WARNING;
                additionalStatus.title = this.i18n.getText("pgp-keyserver-verification.connect.notfound.title");
                additionalStatus.message = this.i18n.getText("pgp-keyserver-verification.connect.notfound.message", new Object[]{this.email});
                statusList.add(additionalStatus);
            } else {
                status.status = EVerificationStatus.ERROR;
                status.title = this.i18n.getText("pgp-keyserver-verification.connect.failure.title");
                status.message = this.i18n.getText("pgp-keyserver-verification.connect.failure.message", new Object[]{url, responseCode, connection.getResponseMessage()});
            }
        }
        catch (ClassCastException e) {
            log.warn("\"" + url + "\" isn't a HTTP-connection.", (Throwable)e);
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("pgp-keyserver-verification.connect.nothttp.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.connect.nothttp.message", new Object[]{url});
        }
        catch (IOException e) {
            log.warn("Could not connect to \"" + url + "\".", (Throwable)e);
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("pgp-keyserver-verification.connect.exception.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.connect.exception.message", new Object[]{url, e.getClass().getSimpleName(), e.getLocalizedMessage()});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void checkResponseForEmail(List<VerificationStatus> statusList, HttpURLConnection connection) {
        log.debug("Checking server response for email {}.", (Object)this.email);
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        IOException e = null;
        boolean emailFound = false;
        try (InputStream is = connection.getInputStream();){
            String encoding = connection.getContentEncoding();
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)(encoding != null ? encoding : "UTF-8"));
            while (lineIterator.hasNext()) {
                String line = StringEscapeUtils.unescapeHtml((String)lineIterator.nextLine());
                log.trace(line);
                if (!line.startsWith("uid:") || !line.contains(this.email)) continue;
                emailFound = true;
                break;
            }
        }
        catch (IOException e1) {
            e = e1;
            log.warn("Error reading server response from: " + connection.getURL(), (Throwable)e);
        }
        log.debug("Email {} found on key server: {}", (Object)this.email, (Object)emailFound);
        if (e != null) {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("pgp-keyserver-verification.checkEmail.exception.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.checkEmail.exception.message", new Object[]{this.email, e.getClass().getSimpleName(), e.getLocalizedMessage()});
        } else if (emailFound) {
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("pgp-keyserver-verification.checkEmail.success.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.checkEmail.success.message", new Object[]{this.email});
        } else {
            status.status = EVerificationStatus.WARNING;
            status.title = this.i18n.getText("pgp-keyserver-verification.checkEmail.failure.title");
            status.message = this.i18n.getText("pgp-keyserver-verification.checkEmail.failure.message", new Object[]{this.email});
        }
    }

    private URL createKeyServerUrl() throws MalformedURLException {
        String file;
        URL url;
        boolean hkpFound = this.location.startsWith("hkp");
        if (hkpFound) {
            hkpFound = true;
            url = new URL("http" + this.location.substring(3));
        } else {
            url = new URL(this.location);
        }
        try {
            file = VERIFY_KEYSERVER_FILE_PART + URLEncoder.encode(this.email, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage(), (Throwable)e);
            file = VERIFY_KEYSERVER_FILE_PART + this.email;
        }
        if (hkpFound && url.getPort() == -1) {
            int port = url.getProtocol().equals("http") ? 11371 : 443;
            url = new URL(url.getProtocol(), url.getHost(), port, file);
        } else {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        return url;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

