/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.ArrayList;
import java.util.List;
import net.savignano.snotify.confluence.gui.PropertiesUtil;
import net.savignano.snotify.confluence.gui.keysource.verification.PgpKeyServerVerification;
import net.savignano.snotify.confluence.gui.keysource.verification.SmimeKeyStoreVerification;
import net.savignano.snotify.confluence.gui.keysource.verification.VerificationStatus;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyKeystoreSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -3672832928332627619L;
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private static final String KEYSTORE_LOCATION_PARAM = "keystore";
    private static final String KEYSERVER_LOCATION_PARAM = "keyserver";
    private static final String EXPIRE_KEYS_PARAM = "expireKeys";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PARAM = "allowPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_PARAM = "allowSmimeCertOverwrite";
    private static final String VERIFY_BUTTON_PARAM = "Test settings";
    private static final Logger log = LoggerFactory.getLogger(SnotifyKeystoreSettingsAction.class);
    private String keyserverLocation;
    private String keystoreLocation;
    private String verifyMessage;
    private boolean expireKeys;
    private boolean allowSmimeOverwrite;
    private boolean allowPgpOverwrite;
    private boolean showUpdated;

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        if (this.keystoreLocation == null) {
            this.readProps();
        }
        return "input";
    }

    public String doSubmit() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.readParams();
        if (this.getCurrentRequest().getParameter(VERIFY_BUTTON_PARAM) != null) {
            return this.verifySettings();
        }
        return this.storeSettings();
    }

    private String storeSettings() {
        this.storeProps();
        this.showUpdated = true;
        return "success";
    }

    private String verifySettings() {
        this.expireKeys = false;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        I18NBean i18n = this.getI18n();
        if (this.keystoreLocation != null && !this.keystoreLocation.isEmpty()) {
            statusList.addAll(this.verifyKeystore(i18n));
        }
        if (this.keyserverLocation != null && !this.keyserverLocation.isEmpty()) {
            statusList.addAll(this.verifyKeyserver(i18n));
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        this.verifyMessage = builder.toString();
        return "input";
    }

    private List<VerificationStatus> verifyKeystore(I18NBean i18n) {
        log.info("Verifying key store at location: {}", (Object)this.keystoreLocation);
        String email = this.getAuthenticatedUser().getEmail();
        SmimeKeyStoreVerification verification = new SmimeKeyStoreVerification(this.keystoreLocation, i18n);
        verification.setEmail(email);
        return verification.verify();
    }

    private List<VerificationStatus> verifyKeyserver(I18NBean i18n) {
        log.info("Verifying PGP key server at location: {}", (Object)this.keyserverLocation);
        String email = this.getAuthenticatedUser().getEmail();
        PgpKeyServerVerification verification = new PgpKeyServerVerification(this.keyserverLocation, i18n);
        verification.setEmail(email);
        return verification.verify();
    }

    public String getCheckedSmimeOverwrite() {
        return this.allowSmimeOverwrite ? CHECKBOX_CHECKED : "";
    }

    public String getCheckedPgpOverwrite() {
        return this.allowPgpOverwrite ? CHECKBOX_CHECKED : "";
    }

    public boolean isShowUpdateInfo() {
        return this.showUpdated;
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }

    public String getKeyserverLocation() {
        return this.keyserverLocation == null ? "" : this.keyserverLocation;
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation == null ? "" : this.keystoreLocation;
    }

    private void readParams() {
        this.keyserverLocation = this.getCurrentRequest().getParameter(KEYSERVER_LOCATION_PARAM);
        this.keystoreLocation = this.getCurrentRequest().getParameter(KEYSTORE_LOCATION_PARAM);
        this.expireKeys = Boolean.parseBoolean(this.getCurrentRequest().getParameter(EXPIRE_KEYS_PARAM));
        this.allowSmimeOverwrite = Boolean.parseBoolean(this.getCurrentRequest().getParameter(ALLOW_SMIME_CERTIFICATE_OVERWRITE_PARAM));
        this.allowPgpOverwrite = Boolean.parseBoolean(this.getCurrentRequest().getParameter(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PARAM));
    }

    private void storeProps() {
        boolean locationChanged = this.isLocationChanged();
        PropertiesUtil.getAppProps().setString("net.savignano.snotify.pgp.keyserverLocation", this.keyserverLocation);
        PropertiesUtil.getAppProps().setString("net.savignano.snotify.smime.keystoreLocation", this.keystoreLocation);
        PropertiesUtil.getAppProps().setBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", this.allowSmimeOverwrite);
        PropertiesUtil.getAppProps().setBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", this.allowPgpOverwrite);
        if (this.expireKeys || locationChanged) {
            PropertiesUtil.getAppProps().setLong("net.savignano.snotify.mailer.expireKeys.timeStamp", System.currentTimeMillis());
        }
    }

    private void readProps() {
        this.keyserverLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.pgp.keyserverLocation");
        this.keystoreLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.smime.keystoreLocation");
        this.allowSmimeOverwrite = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        this.allowPgpOverwrite = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
    }

    private boolean isLocationChanged() {
        String oldKeystoreLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.smime.keystoreLocation");
        if (!StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldKeystoreLocation), (String)StringUtils.stripToNull((String)this.keystoreLocation))) {
            return true;
        }
        String oldKeyserverLocation = PropertiesUtil.getAppProps().getString("net.savignano.snotify.pgp.keyserverLocation");
        return !StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldKeyserverLocation), (String)StringUtils.stripToNull((String)this.keyserverLocation));
    }
}

