/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.keysource.verification;

import com.atlassian.confluence.util.i18n.I18NBean;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import net.savignano.snotify.confluence.gui.Mailer;
import net.savignano.snotify.confluence.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.confluence.gui.keysource.verification.IKeySourceVerification;
import net.savignano.snotify.confluence.gui.keysource.verification.VerificationStatus;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.RDN;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.style.BCStyle;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeKeyStoreVerification
implements IKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeKeyStoreVerification.class);
    private final I18NBean i18n;
    private final String location;
    private String email;

    public SmimeKeyStoreVerification(String location, I18NBean i18n) {
        this.location = location;
        this.i18n = i18n;
    }

    @Override
    public List<VerificationStatus> verify() {
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        this.canReadLocation(statusList);
        return statusList;
    }

    private void canReadLocation(List<VerificationStatus> statusList) {
        SecurityException e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (SecurityException e1) {
            e = e1;
            log.warn("Can not access keystore location: " + this.location, (Throwable)e);
        }
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (canRead) {
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("smime-keystore-verification.canRead.success.title");
            status.message = this.i18n.getText("smime-keystore-verification.canRead.success.message", new Object[]{this.location});
            this.loadKeyStore(statusList);
        } else if (e != null) {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.canRead.exception.title");
            status.message = this.i18n.getText("smime-keystore-verification.canRead.exception.message", new Object[]{this.location, e.getClass().getSimpleName(), e.getLocalizedMessage()});
        } else {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.canRead.failure.title");
            status.message = this.i18n.getText("smime-keystore-verification.canRead.failure.message", new Object[]{this.location});
        }
    }

    private void loadKeyStore(List<VerificationStatus> statusList) {
        Provider provider = Mailer.getProvider();
        Exception e = null;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("BKS", provider);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.location));){
                ks.load(in, null);
                log.debug("Could load key store from location: {}", (Object)this.location);
            }
        }
        catch (Exception e1) {
            e = e1;
            log.warn("Could not load key store from location: " + this.location, (Throwable)e);
        }
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (e == null) {
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("smime-keystore-verification.loadKeyStore.success.title");
            status.message = this.i18n.getText("smime-keystore-verification.loadKeyStore.success.message");
            this.checkEmail(statusList, ks);
        } else {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.loadKeyStore.exception.title");
            status.message = this.i18n.getText("smime-keystore-verification.loadKeyStore.exception.message", new Object[]{e.getClass().getSimpleName(), e.getLocalizedMessage()});
        }
    }

    private void checkEmail(List<VerificationStatus> statusList, KeyStore keyStore) {
        if (keyStore == null) {
            return;
        }
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (this.email == null) {
            status.status = EVerificationStatus.INFO;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.noEmail.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.noEmail.message");
            return;
        }
        Enumeration<String> aliases = null;
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            log.warn("Error getting aliases from keystore.", (Throwable)e);
        }
        boolean emailMatches = false;
        if (aliases != null) {
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate certificate = this.getCertForAlias(keyStore, alias);
                if (!this.isCertForEmail(certificate)) continue;
                emailMatches = true;
                break;
            }
        }
        log.debug("Found email {} in key store: {}", (Object)this.email);
        if (emailMatches) {
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.success.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.success.message", new Object[]{this.email});
        } else {
            status.status = EVerificationStatus.WARNING;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.failure.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.failure.message", new Object[]{this.email});
        }
    }

    private X509Certificate getCertForAlias(KeyStore keyStore, String alias) {
        Certificate cert;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.warn("Error getting certificate for alias: " + alias, (Throwable)e);
            return null;
        }
        if (!(cert instanceof X509Certificate)) {
            log.warn("Certificate found for alias \"{}\" is not a X509Certificate. It will be skipped. Found certificate: {}", new Object[]{alias, cert});
            return null;
        }
        return (X509Certificate)cert;
    }

    private boolean isCertForEmail(X509Certificate certificate) {
        X500Name subject;
        if (certificate == null) {
            return false;
        }
        try {
            subject = new JcaX509CertificateHolder(certificate).getSubject();
        }
        catch (CertificateEncodingException e) {
            log.warn("Error extracting the information from certificate: " + certificate, (Throwable)e);
            return false;
        }
        boolean emailMatches = false;
        String foundEmail = this.getRDNValue(subject, BCStyle.E);
        if (this.email.equalsIgnoreCase(foundEmail)) {
            emailMatches = true;
        } else {
            Collection<List<?>> names = null;
            try {
                names = certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException e) {
                log.warn("Subject Alternative Names Extension could not be parsed from certificate: " + certificate, (Throwable)e);
            }
            if (names != null) {
                for (List<?> item : names) {
                    int type = (Integer)item.get(0);
                    Object value = item.get(1);
                    if (type != 1 || !this.email.equalsIgnoreCase(value.toString())) continue;
                    emailMatches = true;
                    break;
                }
            }
        }
        return emailMatches;
    }

    private String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = name.getRDNs(identifier);
        if (rdns.length == 0) {
            return null;
        }
        return rdns[0].getFirst().getValue().toString();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

