/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg.sig;

import net.savignano.thirdparty.org.bouncycastle.bcpg.SignatureSubpacket;

public class RevocationKey
extends SignatureSubpacket {
    public RevocationKey(boolean isCritical, boolean isLongLength, byte[] data) {
        super(12, isCritical, isLongLength, data);
    }

    public RevocationKey(boolean isCritical, byte signatureClass, int keyAlgorithm, byte[] fingerprint) {
        super(12, isCritical, false, RevocationKey.createData(signatureClass, (byte)(keyAlgorithm & 0xFF), fingerprint));
    }

    private static byte[] createData(byte signatureClass, byte keyAlgorithm, byte[] fingerprint) {
        byte[] data = new byte[2 + fingerprint.length];
        data[0] = signatureClass;
        data[1] = keyAlgorithm;
        System.arraycopy(fingerprint, 0, data, 2, fingerprint.length);
        return data;
    }

    public byte getSignatureClass() {
        return this.getData()[0];
    }

    public int getAlgorithm() {
        return this.getData()[1];
    }

    public byte[] getFingerprint() {
        byte[] data = this.getData();
        byte[] fingerprint = new byte[data.length - 2];
        System.arraycopy(data, 2, fingerprint, 0, fingerprint.length);
        return fingerprint;
    }
}

