/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.html.encode.HtmlEncoder;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.savignano.snotify.confluence.gui.Mailer;
import net.savignano.snotify.confluence.gui.PropertiesUtil;
import net.savignano.snotify.confluence.gui.SnotifyPgpKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.RDN;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.style.BCStyle;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyUserSettingsAction
extends AbstractUserProfileAction {
    private static final long serialVersionUID = -5462548019091147432L;
    private static final String ERROR_EMAIL_MISMATCH = "error-email";
    private static final String ERROR_EXPIRED = "error-expired";
    private static final String ERROR_KEYNOTFOUND = "error-keynotfound";
    private static final String ERROR_NOTYETVALID = "error-notyetvalid";
    private static final String ERROR_PGP = "error-pgp";
    private static final String ERROR_SMIME = "error-smime";
    private static final String FILE_PARAM = "file";
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserSettingsAction.class);
    private Exception lastException;
    private Mailer.EncryptionTypePriorityOption typePriority;
    private Mailer.EncryptionTypePriorityOption lastUpload;
    private Boolean allowSmimeUpload;
    private Boolean allowPgpUpload;

    public String doInput() {
        ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        this.lastUpload = null;
        return "input";
    }

    public String doSubmitSmime() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            log.warn("User is not authenticated for uploading custom S/MIME certificate.");
            return null;
        }
        if (!this.isAllowSmimeUpload()) {
            log.warn("Uploading of custom S/MIME certificate is not allowed. User: {}", (Object)user);
            return this.doInput();
        }
        this.lastUpload = Mailer.EncryptionTypePriorityOption.SMIME_ONLY;
        MultiPartRequestWrapper requestWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        if (requestWrapper.hasErrors()) {
            Collection errors = requestWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                this.addActionError((String)i.next());
            }
            return "error";
        }
        File certFile = null;
        File[] files = requestWrapper.getFiles(FILE_PARAM);
        if (files != null && files.length > 0) {
            certFile = files[0];
        }
        try {
            byte[] cert = certFile != null ? Files.readAllBytes(certFile.toPath()) : null;
            this.setEmailCert(cert, user);
            return "success";
        }
        catch (EmailException e) {
            this.lastException = e;
            log.info("Email address mismatch.", (Throwable)e);
            return ERROR_EMAIL_MISMATCH;
        }
        catch (CertificateExpiredException e) {
            this.lastException = e;
            log.info("Certificate expired.", (Throwable)e);
            return ERROR_EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            this.lastException = e;
            log.info("Certificate not yet valid.", (Throwable)e);
            return ERROR_NOTYETVALID;
        }
        catch (IOException | CertificateException e) {
            this.lastException = e;
            log.info("Certificate parsing failed.", (Throwable)e);
            return ERROR_SMIME;
        }
    }

    public String doSubmitPgp() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            log.warn("User is not authenticated for uploading custom PGP key.");
            return null;
        }
        if (!this.isAllowPgpUpload()) {
            log.warn("Uploading of custom PGP key is not allowed. User: {}", (Object)user);
            return null;
        }
        this.lastUpload = Mailer.EncryptionTypePriorityOption.PGP_ONLY;
        MultiPartRequestWrapper requestWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        if (requestWrapper.hasErrors()) {
            Collection errors = requestWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                this.addActionError((String)i.next());
            }
            return "error";
        }
        File keyFile = null;
        File[] files = requestWrapper.getFiles(FILE_PARAM);
        if (files != null && files.length > 0) {
            keyFile = files[0];
        }
        try {
            byte[] key = keyFile != null ? Files.readAllBytes(keyFile.toPath()) : null;
            this.setEmailPgpKey(key, user);
            return "success";
        }
        catch (IOException | PGPException e) {
            this.lastException = e;
            log.info("Key parsing failed.", (Throwable)e);
            return ERROR_PGP;
        }
        catch (KeyException e) {
            this.lastException = e;
            log.info("No valid key found.", (Throwable)e);
            return ERROR_KEYNOTFOUND;
        }
    }

    private void setEmailCert(byte[] cert, ConfluenceUser user) throws CertificateException {
        if (cert == null || cert.length == 0) {
            log.debug("Clearing certificate for user: " + user.getFullName());
            PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.smime.cert", null, (User)user);
            PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.smime.timeStamp", null, (User)user);
            PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.smime.keySource", null, (User)user);
        } else {
            log.debug("Checking certificate for user: " + user.getFullName());
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
            certificate.checkValidity();
            JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(certificate);
            String certEmail = this.getSmimeEmails(certificate, certHolder.getSubject()).toLowerCase();
            if (!certEmail.contains(user.getEmail().toLowerCase())) {
                throw new EmailException(certEmail, user.getFullName());
            }
            log.debug("Setting certificate for user: " + user.getFullName());
            PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.smime.cert", cert, (User)user);
            PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.smime.timeStamp", System.currentTimeMillis(), (User)user);
            PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.smime.keySource", Mailer.EncryptionKeySource.USER, (User)user);
        }
    }

    private void setEmailPgpKey(byte[] key, ConfluenceUser user) throws IOException, PGPException, KeyException {
        if (key == null || key.length == 0) {
            log.info("Clearing PGP key for user: {}", (Object)user.getFullName());
            PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.pgp.key", null, (User)user);
            PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.pgp.key.id", null, (User)user);
            PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.pgp.timeStamp", null, (User)user);
            PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.pgp.keySource", null, (User)user);
        } else {
            SnotifyPgpKey usedKey;
            log.debug("Checking PGP key for user: {}", (Object)user.getFullName());
            String userEmailAddress = user.getEmail().toLowerCase();
            try (InputStream decoderStream = PGPUtil.getDecoderStream(new ByteArrayInputStream(key));){
                PGPPublicKeyRingCollection keyRings = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                usedKey = new SnotifyPgpKey(keyRings, userEmailAddress);
            }
            PGPPublicKey encKey = usedKey.getEncryptionKey();
            if (encKey == null) {
                throw new KeyException("Could not find a valid encryption key.");
            }
            log.info("Setting PGP key for user: {}", (Object)user.getFullName());
            PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.pgp.key", key, (User)user);
            PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.pgp.key.id", encKey.getKeyID(), (User)user);
            PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.pgp.timeStamp", System.currentTimeMillis(), (User)user);
            PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.pgp.keySource", Mailer.EncryptionKeySource.USER, (User)user);
        }
    }

    private String buildCertInfo(byte[] cert) throws CertificateException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
        JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(certificate);
        X500Name issuer = certHolder.getIssuer();
        X500Name subject = certHolder.getSubject();
        ResourceBundle resourceBundle = this.getDefaultResourceBundle();
        ConfluenceUser profileUser = this.getUser();
        StringBuilder builder = new StringBuilder(500);
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.type"), resourceBundle.getString("snotify-user-settings-item.input.smime.type"), "type-smime");
        Long timeStamp = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.smime.timeStamp", (User)profileUser);
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.uploadTime"), timeStamp == null ? "N/A" : new Date(timeStamp), "key-uploadTime");
        Mailer.EncryptionKeySource keySource = PropertiesUtil.getUserProps().getEnum("net.savignano.snotify.email.smime.keySource", Mailer.EncryptionKeySource.class, (User)profileUser);
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.uploadBy"), keySource == null ? "N/A" : resourceBundle.getString("encryption-key-source." + keySource.name()), "key-uploadBy");
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.smime.cert.valid"), certificate.getNotBefore(), "cert-valid");
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.smime.cert.expires"), certificate.getNotAfter(), "cert-expires");
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.smime.cert.for"), this.getRDNValue(subject, BCStyle.CN) + " (" + this.getSmimeEmails(certificate, subject) + ")", "cert-subject");
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.smime.cert.issuer"), this.getRDNValue(issuer, BCStyle.CN) + " (" + this.getSmimeEmails(null, issuer) + ")", "cert-issuer");
        this.buildEntry(builder, resourceBundle.getString("snotify-user-settings-item.input.smime.cert.algorithm"), certificate.getSigAlgName(), "cert-algorithm");
        return builder.toString();
    }

    private String getSmimeEmails(X509Certificate certificate, X500Name name) throws CertificateParsingException {
        Collection<List<?>> altNames;
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        String email = this.getRDNValue(name, BCStyle.E);
        if (email != null) {
            emails.add(email);
        }
        if (certificate != null && (altNames = certificate.getSubjectAlternativeNames()) != null) {
            for (List<?> item : altNames) {
                int type = (Integer)item.get(0);
                Object value = item.get(1);
                if (type != 1 || value == null) continue;
                emails.add(value.toString());
            }
        }
        if (emails.isEmpty()) {
            return "N/A";
        }
        return StringUtils.join(emails, (String)", ");
    }

    private String buildKeyInfo(byte[] key, long keyId) throws IOException, PGPException {
        PGPPublicKeyRingCollection coll;
        try (InputStream decoderStream = PGPUtil.getDecoderStream(new ByteArrayInputStream(key));){
            coll = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        }
        SnotifyPgpKey publicKey = null;
        Iterator<PGPPublicKeyRing> iter = coll.getKeyRings();
        while (iter.hasNext()) {
            PGPPublicKeyRing ring = iter.next();
            if (ring.getPublicKey(keyId) == null) continue;
            publicKey = new SnotifyPgpKey(ring);
            break;
        }
        if (publicKey == null) {
            throw new PGPException("No public key found for ID: " + Long.toHexString(keyId).toUpperCase());
        }
        ResourceBundle resources = this.getDefaultResourceBundle();
        ConfluenceUser profileUser = this.getUser();
        StringBuilder builder = new StringBuilder(500);
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.type"), resources.getString("snotify-user-settings-item.input.pgp.type"), "type-pgp");
        Long timeStamp = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.pgp.timeStamp", (User)profileUser);
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.uploadTime"), timeStamp == null ? "N/A" : new Date(timeStamp), "key-uploadTime");
        Mailer.EncryptionKeySource keySource = PropertiesUtil.getUserProps().getEnum("net.savignano.snotify.email.pgp.keySource", Mailer.EncryptionKeySource.class, (User)profileUser);
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.uploadBy"), keySource == null ? "N/A" : resources.getString("encryption-key-source." + keySource.name()), "key-uploadBy");
        PGPPublicKey masterKey = publicKey.getMasterKey();
        PGPPublicKey encKey = publicKey.getKey(keyId);
        if (encKey == null && (encKey = publicKey.getEncryptionKey()) == null) {
            encKey = masterKey;
        }
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.pgp.key.valid"), masterKey.getCreationTime(), "key-valid");
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.pgp.key.id"), this.getPrettyPrintId(masterKey.getKeyID(), this.getLocale()), "key-id");
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.pgp.key.fingerprint"), this.getPrettyPrintFingerprint(masterKey.getFingerprint(), this.getLocale()), "key-fingerprint");
        if (encKey.getKeyID() != masterKey.getKeyID()) {
            this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.pgp.key.encKeyId"), this.getPrettyPrintId(encKey.getKeyID(), this.getLocale()), "key-encryption");
        }
        Object expires = encKey.getValidSeconds() == 0L ? resources.getString("snotify-user-settings-item.input.pgp.key.expires.never") : new Date(encKey.getCreationTime().getTime() + encKey.getValidSeconds());
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.pgp.key.expires"), expires, "key-expires");
        ArrayList<String> users = new ArrayList<String>();
        Iterator<String> iter2 = masterKey.getUserIDs();
        while (iter2.hasNext()) {
            users.add(iter2.next());
        }
        this.buildEntry(builder, resources.getString("snotify-user-settings-item.input.pgp.key.users"), StringUtils.join(users, (String)", "), "key-users");
        return builder.toString();
    }

    private String getPrettyPrintId(long id, Locale locale) {
        String prettyId = Long.toHexString(id);
        if (prettyId.length() > 8) {
            prettyId = prettyId.substring(prettyId.length() - 8);
        } else if (prettyId.length() < 8) {
            prettyId = StringUtils.leftPad((String)prettyId, (int)8, (char)'0');
        }
        prettyId = locale == null ? prettyId.toUpperCase() : prettyId.toUpperCase(locale);
        return prettyId;
    }

    private String getPrettyPrintFingerprint(byte[] fingerprint, Locale locale) {
        String full = Hex.toHexString(fingerprint).toUpperCase();
        full = locale == null ? full.toUpperCase() : full.toUpperCase(locale);
        StringBuilder builder = new StringBuilder(full.length() + full.length() / 4);
        int space = -1;
        for (char c : full.toCharArray()) {
            if (++space == 4) {
                builder.append(' ');
                space = 0;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = name.getRDNs(identifier);
        if (rdns.length == 0) {
            return null;
        }
        return rdns[0].getFirst().getValue().toString();
    }

    private void buildEntry(StringBuilder builder, String label, Object value, String id) {
        builder.append("<tr>");
        if (id == null) {
            builder.append("<th align=\"right\">");
        } else {
            builder.append("<th align=\"right\" id=\"");
            builder.append(HtmlEncoder.encode((String)id));
            builder.append("\">");
        }
        builder.append(HtmlEncoder.encode((String)label));
        builder.append(":</th><td>");
        if (value == null) {
            builder.append("N/A");
        } else {
            builder.append(HtmlEncoder.encode((String)value.toString()));
        }
        builder.append("</td></tr>\n");
    }

    public String getErrorMessage() {
        return this.lastException == null ? null : this.lastException.getMessage();
    }

    @HtmlSafe
    public String getCertDetails() {
        ConfluenceUser profileUser = this.getUser();
        byte[] cert = PropertiesUtil.getUserProps().getBytes("net.savignano.snotify.email.smime.cert", (User)profileUser);
        String info = null;
        if (cert == null) {
            info = this.getText("snotify-user-settings-item.input.smime.notfound");
            log.debug("No certificate specified for user: {}", (Object)profileUser.getFullName());
        } else {
            try {
                info = this.buildCertInfo(cert);
                log.debug("Certificate information for user {}: {}", (Object)profileUser.getFullName(), (Object)info);
            }
            catch (CertificateException e) {
                log.warn("Could not load public certificate for user: " + profileUser.getFullName(), (Throwable)e);
                info = this.getText("snotify-user-settings-item.input.smime.error", new String[]{e.getLocalizedMessage()});
            }
        }
        return info;
    }

    @HtmlSafe
    public String getPgpDetails() {
        ConfluenceUser profileUser = this.getUser();
        byte[] key = PropertiesUtil.getUserProps().getBytes("net.savignano.snotify.email.pgp.key", (User)profileUser);
        Long keyId = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.pgp.key.id", (User)profileUser);
        String info = null;
        if (key == null || keyId == null) {
            info = this.getText("snotify-user-settings-item.input.pgp.notfound");
            log.debug("No certificate specified for user: {}", (Object)profileUser.getFullName());
        } else {
            try {
                info = this.buildKeyInfo(key, keyId);
                log.debug("Key information for user {}: {}", (Object)profileUser.getFullName(), (Object)info);
            }
            catch (IOException | PGPException e) {
                log.warn("Could not load PGP key for user: " + profileUser.getFullName(), (Throwable)e);
                info = this.getText("snotify-user-settings-item.input.pgp.error", e.getLocalizedMessage());
            }
        }
        return info;
    }

    public boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERED: 
            case PGP_PREFERED: {
                return true;
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isSmimeSelected() {
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERED: {
                return this.lastUpload != Mailer.EncryptionTypePriorityOption.PGP_ONLY;
            }
            case PGP_PREFERED: {
                return this.lastUpload == Mailer.EncryptionTypePriorityOption.SMIME_ONLY;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isPgpSelected() {
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERED: {
                return this.lastUpload == Mailer.EncryptionTypePriorityOption.PGP_ONLY;
            }
            case PGP_PREFERED: {
                return this.lastUpload != Mailer.EncryptionTypePriorityOption.SMIME_ONLY;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    public boolean isSmimeUploadAllowed() {
        return this.isAllowSmimeUpload();
    }

    public boolean isPgpUploadAllowed() {
        return this.isAllowPgpUpload();
    }

    private Mailer.EncryptionTypePriorityOption getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = PropertiesUtil.getAppProps().getEnum("net.savignano.snotify.mailer.encryptionTypePriority", Mailer.EncryptionTypePriorityOption.class);
            if (this.typePriority == null) {
                this.typePriority = Mailer.EncryptionTypePriorityOption.SMIME_PREFERED;
            }
        }
        return this.typePriority;
    }

    private boolean isAllowSmimeUpload() {
        if (this.allowSmimeUpload == null) {
            this.allowSmimeUpload = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        }
        return this.allowSmimeUpload;
    }

    private boolean isAllowPgpUpload() {
        if (this.allowPgpUpload == null) {
            this.allowPgpUpload = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
        }
        return this.allowPgpUpload;
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = -5262905856665194L;

        private EmailException(String email, String user) {
            super("Email address(es) of certificate (" + email + ") do not match email of user: " + user);
        }
    }
}

