/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.eac;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ApplicationSpecific;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ParsingException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERApplicationSpecific;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.CertificateBody;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.CertificateHolderReference;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.CertificationAuthorityReference;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.Flags;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.PackedDate;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CVCertificate
extends ASN1Object {
    private CertificateBody certificateBody;
    private byte[] signature;
    private int valid;
    private static int bodyValid = 1;
    private static int signValid = 2;

    private void setPrivateData(ASN1ApplicationSpecific appSpe) throws IOException {
        ASN1InputStream content;
        this.valid = 0;
        if (appSpe.getApplicationTag() == 33) {
            ASN1Primitive tmpObj;
            content = new ASN1InputStream(appSpe.getContents());
            block4: while ((tmpObj = content.readObject()) != null) {
                if (tmpObj instanceof DERApplicationSpecific) {
                    DERApplicationSpecific aSpe = (DERApplicationSpecific)tmpObj;
                    switch (aSpe.getApplicationTag()) {
                        case 78: {
                            this.certificateBody = CertificateBody.getInstance(aSpe);
                            this.valid |= bodyValid;
                            continue block4;
                        }
                        case 55: {
                            this.signature = aSpe.getContents();
                            this.valid |= signValid;
                            continue block4;
                        }
                    }
                    throw new IOException("Invalid tag, not an Iso7816CertificateStructure :" + aSpe.getApplicationTag());
                }
                throw new IOException("Invalid Object, not an Iso7816CertificateStructure");
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE :" + appSpe.getApplicationTag());
        }
        content.close();
        if (this.valid != (signValid | bodyValid)) {
            throw new IOException("invalid CARDHOLDER_CERTIFICATE :" + appSpe.getApplicationTag());
        }
    }

    public CVCertificate(ASN1InputStream aIS) throws IOException {
        this.initFrom(aIS);
    }

    private void initFrom(ASN1InputStream aIS) throws IOException {
        ASN1Primitive obj;
        while ((obj = aIS.readObject()) != null) {
            if (obj instanceof DERApplicationSpecific) {
                this.setPrivateData((DERApplicationSpecific)obj);
                continue;
            }
            throw new IOException("Invalid Input Stream for creating an Iso7816CertificateStructure");
        }
    }

    private CVCertificate(ASN1ApplicationSpecific appSpe) throws IOException {
        this.setPrivateData(appSpe);
    }

    public CVCertificate(CertificateBody body, byte[] signature) throws IOException {
        this.certificateBody = body;
        this.signature = Arrays.clone(signature);
        this.valid |= bodyValid;
        this.valid |= signValid;
    }

    public static CVCertificate getInstance(Object obj) {
        if (obj instanceof CVCertificate) {
            return (CVCertificate)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificate(DERApplicationSpecific.getInstance(obj));
            }
            catch (IOException e) {
                throw new ASN1ParsingException("unable to parse data: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public byte[] getSignature() {
        return Arrays.clone(this.signature);
    }

    public CertificateBody getBody() {
        return this.certificateBody;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certificateBody);
        try {
            v.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.signature)));
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to convert signature!");
        }
        return new DERApplicationSpecific(33, v);
    }

    public ASN1ObjectIdentifier getHolderAuthorization() throws IOException {
        CertificateHolderAuthorization cha = this.certificateBody.getCertificateHolderAuthorization();
        return cha.getOid();
    }

    public PackedDate getEffectiveDate() throws IOException {
        return this.certificateBody.getCertificateEffectiveDate();
    }

    public int getCertificateType() {
        return this.certificateBody.getCertificateType();
    }

    public PackedDate getExpirationDate() throws IOException {
        return this.certificateBody.getCertificateExpirationDate();
    }

    public int getRole() throws IOException {
        CertificateHolderAuthorization cha = this.certificateBody.getCertificateHolderAuthorization();
        return cha.getAccessRights();
    }

    public CertificationAuthorityReference getAuthorityReference() throws IOException {
        return this.certificateBody.getCertificationAuthorityReference();
    }

    public CertificateHolderReference getHolderReference() throws IOException {
        return this.certificateBody.getCertificateHolderReference();
    }

    public int getHolderAuthorizationRole() throws IOException {
        int rights = this.certificateBody.getCertificateHolderAuthorization().getAccessRights();
        return rights & 0xC0;
    }

    public Flags getHolderAuthorizationRights() throws IOException {
        return new Flags(this.certificateBody.getCertificateHolderAuthorization().getAccessRights() & 0x1F);
    }
}

