/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSRuntimeException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSTypedStream;

public class PKCS7TypedStream
extends CMSTypedStream {
    private final ASN1Encodable content;

    public PKCS7TypedStream(ASN1ObjectIdentifier oid, ASN1Encodable encodable) throws IOException {
        super(oid);
        this.content = encodable;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    public InputStream getContentStream() {
        try {
            return this.getContentStream(this.content);
        }
        catch (IOException e) {
            throw new CMSRuntimeException("unable to convert content to stream: " + e.getMessage(), e);
        }
    }

    public void drain() throws IOException {
        this.getContentStream(this.content);
    }

    private InputStream getContentStream(ASN1Encodable encodable) throws IOException {
        byte[] encoded = encodable.toASN1Primitive().getEncoded("DER");
        int index = 1;
        while ((encoded[index] & 0xFF) > 127) {
            ++index;
        }
        return new ByteArrayInputStream(encoded, ++index, encoded.length - index);
    }
}

