/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.tls;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.AbstractTlsClient;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsAuthentication;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsCipherFactory;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsKeyExchange;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsPSKIdentity;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import net.savignano.thirdparty.org.bouncycastle.crypto.tls.TlsUtils;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.pskIdentity = pskIdentity;
    }

    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

