/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common;

import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.ISnotifyProjectProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyProjectProperties
implements ISnotifyProjectProperties {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyProjectProperties.class);
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";

    @Override
    public boolean hasKey(String key, String projectName) {
        return this.getString(key, projectName) != null || this.getUnlimitedString(key, projectName) != null;
    }

    @Override
    public String getUnlimitedString(String key, String projectName) {
        if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, projectName)) {
            return null;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, projectName);
        if (pagesValue == null) {
            return null;
        }
        int pages = pagesValue.intValue();
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = this.getString(key + SETTINGS_STRING_PAGE + i, projectName);
            builder.append(page);
        }
        String value = builder.toString();
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String key, String projectName) {
        return this.getBoolean(key, false, projectName);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, String projectName) {
        String value = this.getString(key, projectName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public Long getLong(String key, String projectName) {
        String value = this.getString(key, projectName);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Value " + value + " stored in projectName property " + key + " for projectName " + projectName + " is not a Long.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> clazz, String projectName) {
        String value = this.getString(key, projectName);
        if (value != null) {
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error("Value " + value + " stored in application property " + key + " for projectName " + projectName + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public byte[] getBytes(String key, String projectName) {
        String base64Value = this.getUnlimitedString(key, projectName);
        if (base64Value != null) {
            return Base64.decodeBase64((byte[])base64Value.getBytes(Constants.UTF8_CHARSET));
        }
        return null;
    }

    @Override
    public void setUnlimitedString(String key, String value, String projectName) {
        this.removeUnlimitedString(key, projectName);
        if (value != null) {
            int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
            if (pages > 0) {
                for (int i = 0; i < pages - 1; ++i) {
                    this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255), projectName);
                }
                this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255), projectName);
            }
            this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages), projectName);
            this.setBoolean(key + SETTINGS_STRING_EXISTS, true, projectName);
        }
    }

    private void removeUnlimitedString(String key, String projectName) {
        if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, projectName)) {
            return;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, projectName);
        if (pagesValue == null) {
            return;
        }
        this.setString(key + SETTINGS_STRING_EXISTS, null, projectName);
        this.setLong(key + SETTINGS_STRING_PAGES, null, projectName);
        int pages = pagesValue.intValue();
        for (int i = 0; i < pages; ++i) {
            this.setString(key + SETTINGS_STRING_PAGE + i, null, projectName);
        }
    }

    @Override
    public void setBoolean(String key, boolean value, String projectName) {
        this.setString(key, String.valueOf(value), projectName);
    }

    @Override
    public void setLong(String key, Long value, String projectName) {
        this.setString(key, value == null ? null : value.toString(), projectName);
    }

    @Override
    public void setEnum(String key, Enum<?> value, String projectName) {
        this.setString(key, value == null ? null : value.name(), projectName);
    }

    @Override
    public void setBytes(String key, byte[] value, String projectName) {
        String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Constants.UTF8_CHARSET);
        this.setUnlimitedString(key, encoded, projectName);
    }
}

