/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.key.info;

import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.gui.ISnotifyI18n;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class AKeyInfoBuilder {
    private final ISnotifyI18n i18n;
    private ISnotifyUserProperties userProps;
    private IUser user;

    public AKeyInfoBuilder(ISnotifyI18n i18n) {
        this.i18n = i18n;
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
    }

    void buildHtmlEntry(AtlassianStyle style, StringBuilder builder, String label, Object value, String id) {
        switch (style) {
            case CONFLUENCE: {
                this.buildConfluenceHtmlEntry(builder, label, value, id);
                break;
            }
            case JIRA: {
                this.buildJiraHtmlEntry(builder, label, value, id);
                break;
            }
            default: {
                throw new IllegalStateException("AtlassianStyle not implemented: " + (Object)((Object)style));
            }
        }
    }

    private void buildConfluenceHtmlEntry(StringBuilder builder, String label, Object value, String id) {
        builder.append("<tr>");
        if (id == null) {
            builder.append("<th align=\"right\">");
        } else {
            builder.append("<th align=\"right\" id=\"");
            builder.append(StringEscapeUtils.escapeHtml((String)id));
            builder.append("\">");
        }
        builder.append(StringEscapeUtils.escapeHtml((String)label));
        builder.append(":</th><td>");
        if (value == null) {
            builder.append("N/A");
        } else {
            builder.append(StringEscapeUtils.escapeHtml((String)value.toString()));
        }
        builder.append("</td></tr>\n");
    }

    private void buildJiraHtmlEntry(StringBuilder builder, String label, Object value, String id) {
        builder.append("<dl>");
        builder.append("<dt>");
        builder.append(StringEscapeUtils.escapeHtml((String)label));
        builder.append(":</dt>");
        if (id == null) {
            builder.append("<dd>");
        } else {
            builder.append("<dd = id=\"");
            builder.append(StringEscapeUtils.escapeHtml((String)id));
            builder.append("\">");
        }
        if (value == null) {
            builder.append("N/A");
        } else {
            builder.append(StringEscapeUtils.escapeHtml((String)value.toString()));
        }
        builder.append("</dd>");
        builder.append("</dl>");
    }

    public ISnotifyI18n getI18n() {
        return this.i18n;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }

    public void setUserProps(ISnotifyUserProperties userProps) {
        this.userProps = userProps;
    }

    public IUser getUser() {
        return this.user;
    }

    public void setUser(IUser user) {
        this.user = user;
    }

    static enum AtlassianStyle {
        CONFLUENCE,
        JIRA;

    }
}

