/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.util.Option;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.security.MyJCE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class LicenseListener {
    private static final Logger log = LoggerFactory.getLogger(LicenseListener.class);
    private static final String CONFIG_FILE = "/images/tiny_logo.png";
    private static final String FULL_CAPABILITY = "Managed";
    private static final String SKIP_SIGNATURE = "SkipSig";
    @Inject
    @ComponentImport
    private PluginController controller;
    @Inject
    @ComponentImport
    private EventPublisher publisher;
    @Inject
    @ComponentImport
    private PluginLicenseEventRegistry pluginPublisher;
    @Inject
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @Inject
    private ISnotifyAppProperties appProperties;

    @PostConstruct
    public void init() {
        log.debug("Initializing S/Notify License Listener.");
        this.publisher.register((Object)this);
        this.pluginPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        log.debug("Destroying S/Notify License Listener.");
        this.publisher.unregister((Object)this);
        this.pluginPublisher.unregister((Object)this);
    }

    private boolean isRelevant(PluginEvent event) {
        return this.isRelevant(event.getPlugin().getKey());
    }

    private boolean isRelevant(String pluginKey) {
        return this.licenseManager.getPluginKey().equalsIgnoreCase(pluginKey);
    }

    @EventListener
    public void refresh(PluginRefreshedEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Refreshed Event for S/Notify detected: {}", (Object)event);
            String config = this.getConfig();
            if (this.checkSignature(config)) {
                this.checkLite(config);
                this.checkLicense();
            }
        }
    }

    @EventListener
    public void enabled(PluginEnabledEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Enabled Event for S/Notify detected: {}", (Object)event);
            this.setDisablement(false);
            String config = this.getConfig();
            if (this.checkSignature(config)) {
                this.checkLite(config);
                this.checkLicense();
            }
        }
    }

    @EventListener
    public void disabled(PluginDisablingEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Disabling Event for S/Notify detected: {}", (Object)event);
            this.setDisablement(true);
        }
    }

    @EventListener
    public void startup(PluginFrameworkStartedEvent event) {
        log.debug("Plugin Framework Start Event for S/Notify detected: {}", (Object)event);
        String config = this.getConfig();
        if (this.checkSignature(config)) {
            this.checkLite(config);
            this.checkLicense();
        }
    }

    @EventListener
    public void license(PluginLicenseEvent event) {
        if (this.isRelevant(event.getPluginKey())) {
            log.debug("Plugin License Event for S/Notify detected: {}", (Object)event);
            this.checkLite(this.getConfig());
            this.checkLicense();
        }
    }

    private void setDisablement(boolean disable) {
        boolean oldDisabled = this.appProperties.getBoolean("net.savignano.snotify.mailer.disable");
        if (oldDisabled != disable) {
            if (disable) {
                log.info("Disabling S/Notify mailer.");
            } else {
                log.info("Enabling S/Notify mailer.");
            }
            this.appProperties.setBoolean("net.savignano.snotify.mailer.disable", disable);
        }
    }

    private void checkLicense() {
        this.printLicense();
        boolean freeze = this.isFreezeSnotify();
        boolean oldFreeze = this.appProperties.getBoolean("net.savignano.snotify.mailer.freeze");
        if (oldFreeze != freeze) {
            if (freeze) {
                log.info("S/Notify mailer was frozen because of an invalid license.");
            } else {
                log.info("S/Notify mailer was restored. Proper license found.");
            }
            this.appProperties.setBoolean("net.savignano.snotify.mailer.freeze", freeze);
        }
    }

    private void checkLite(String config) {
        boolean oldLite = this.appProperties.getBoolean("net.savignano.snotify.lite.mode");
        if (config != null) {
            if (config.contains(FULL_CAPABILITY)) {
                log.info("S/Notify Professional version recognized.");
                if (oldLite) {
                    this.appProperties.setBoolean("net.savignano.snotify.lite.mode", false);
                }
            } else {
                log.info("S/Notify Lite version recognized.");
                if (!oldLite) {
                    this.appProperties.setBoolean("net.savignano.snotify.lite.mode", true);
                }
            }
        }
    }

    private boolean checkSignature(String config) {
        if (config != null && config.contains(SKIP_SIGNATURE)) {
            log.debug("Skipping signature check.");
            return true;
        }
        if (MyJCE.selfIntegrityChecking()) {
            log.info("Signature of S/Notify is correct.");
            return true;
        }
        log.error("Signature of S/Notify is not correct. S/Notify will be disabled, as it has been tempered with to protect underlying system.");
        this.controller.disablePluginWithoutPersisting(this.licenseManager.getPluginKey());
        return false;
    }

    private boolean isFreezeSnotify() {
        Option licenseOption = this.licenseManager.getLicense();
        if (licenseOption.isDefined()) {
            PluginLicense license = (PluginLicense)licenseOption.get();
            return !license.isValid() && license.isEvaluation();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfig() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(CONFIG_FILE), Constants.UTF8_CHARSET));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            log.error("Could not access config file.", (Throwable)e);
            return null;
        }
    }

    private void printLicense() {
        if (!log.isDebugEnabled()) {
            return;
        }
        Option option = this.licenseManager.getLicense();
        if (option.isDefined()) {
            PluginLicense license = (PluginLicense)option.get();
            log.debug("S/Notify license: {}", (Object)license);
            if (license.getError().isDefined()) {
                LicenseError licenseError = (LicenseError)license.getError().get();
                log.debug("S/Notify license error: {}", (Object)licenseError);
            }
        } else {
            log.debug("No license for S/Notify defined.");
        }
    }
}

