/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.confluence.gui.SnotifyAppProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TweakSnotifyAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 191752335478523820L;
    private static final Logger log = LoggerFactory.getLogger(TweakSnotifyAction.class);
    private final ISnotifyAppProperties appProps = new SnotifyAppProperties();
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    private boolean showUpdated;

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        return "input";
    }

    public String doAdd() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        String value = this.getCurrentRequest().getParameter(VALUE_PARAM);
        log.debug("Adding key/value pair to tweaks: {} = {}", (Object)key, (Object)value);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            log.debug("Key or Value is considered empty. Tweak will not be added.");
            return "input";
        }
        this.appProps.setString("net.savignano.snotify.tweak." + key, value);
        Map<String, String> tweaks = this.getTweaks();
        tweaks.put(key, value);
        this.setTweaks(tweaks);
        this.showUpdated = true;
        return "input";
    }

    public String doDelete() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        log.debug("Removing key from tweaks: {} = {}", (Object)key);
        if (StringUtils.isBlank((CharSequence)key)) {
            log.debug("Key is considered empty. Tweak will not be removed.");
            return "input";
        }
        this.appProps.setString("net.savignano.snotify.tweak." + key, null);
        Map<String, String> tweaks = this.getTweaks();
        tweaks.remove(key);
        this.setTweaks(tweaks);
        this.showUpdated = true;
        return "input";
    }

    public boolean isShowUpdateInfo() {
        return this.showUpdated;
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getTweaks().entrySet();
    }

    private Map<String, String> getTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.appProps.getUnlimitedString("net.savignano.snotify.tweak.overview");
        if (tweakString != null) {
            for (String oneTweak : tweakString.split("\\;")) {
                String[] keyValue = oneTweak.split("\\=");
                if (keyValue.length == 2) {
                    tweaks.put(keyValue[0], keyValue[1]);
                    continue;
                }
                log.warn("Unknown key/value format ({}) detected in tweaks: {}", (Object)keyValue, (Object)tweakString);
            }
        }
        return tweaks;
    }

    private void setTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.appProps.setUnlimitedString("net.savignano.snotify.tweak.overview", null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
                builder.append(";");
            }
            builder.deleteCharAt(builder.lastIndexOf(";"));
            this.appProps.setUnlimitedString("net.savignano.snotify.tweak.overview", builder.toString());
        }
    }
}

