/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pkcs.bc;

import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.operator.MacCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.bc.BcDigestProvider;
import net.savignano.thirdparty.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import net.savignano.thirdparty.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import net.savignano.thirdparty.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

