/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.key.info;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.util.CertUtil;
import net.savignano.snotify.atlassian.gui.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.key.info.AKeyInfoBuilder;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.style.BCStyle;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.apache.commons.lang.StringUtils;

public class SmimeCertInfoBuilder
extends AKeyInfoBuilder {
    private final X509Certificate certificate;

    public SmimeCertInfoBuilder(X509Certificate certificate, ISnotifyI18n i18n) {
        super(i18n);
        this.certificate = certificate;
        if (certificate == null) {
            throw new IllegalArgumentException("Certificate must not be null.");
        }
    }

    public SmimeCertInfoBuilder(byte[] certificate, ISnotifyI18n i18n) throws CertificateException {
        this((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate)), i18n);
    }

    public String buildConfluenceHtml() throws CertificateException {
        return this.buildHtml(AKeyInfoBuilder.AtlassianStyle.CONFLUENCE);
    }

    public String buildJiraHtml() throws CertificateException {
        return this.buildHtml(AKeyInfoBuilder.AtlassianStyle.JIRA);
    }

    private String buildHtml(AKeyInfoBuilder.AtlassianStyle style) throws CertificateException {
        JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(this.certificate);
        X500Name issuer = certHolder.getIssuer();
        X500Name subject = certHolder.getSubject();
        StringBuilder builder = new StringBuilder(500);
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.type"), this.getI18n().getText("info-builder.smime.type"), "type-smime");
        if (this.getUser() != null && this.getUserProps() != null) {
            Long timeStamp = this.getUserProps().getLong("net.savignano.snotify.email.smime.timeStamp", this.getUser());
            this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.uploadTime"), timeStamp == null ? "N/A" : new Date(timeStamp), "key-uploadTime");
            EncryptionKeySource keySource = this.getUserProps().getEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.class, this.getUser());
            this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.uploadBy"), keySource == null ? "N/A" : this.getI18n().getText("encryption-key-source." + keySource.name()), "key-uploadBy");
        }
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.smime.cert.valid"), this.certificate.getNotBefore(), "cert-valid");
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.smime.cert.expires"), this.certificate.getNotAfter(), "cert-expires");
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.smime.cert.for"), this.getRDNValue(subject, BCStyle.CN) + " (" + this.getEmails() + ")", "cert-subject");
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.smime.cert.issuer"), this.getRDNValue(issuer, BCStyle.CN) + " (" + this.getIssuerEmails() + ")", "cert-issuer");
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.smime.cert.algorithm"), this.certificate.getSigAlgName(), "cert-algorithm");
        return builder.toString();
    }

    private String getEmails() throws CertificateException {
        Object[] emails = CertUtil.getEmails(this.certificate);
        if (emails.length == 0) {
            return "N/A";
        }
        return StringUtils.join((Object[])emails, (String)", ");
    }

    private String getIssuerEmails() throws CertificateException {
        Object[] emails = CertUtil.getIssuerEmails(this.certificate);
        if (emails.length == 0) {
            return "N/A";
        }
        return StringUtils.join((Object[])emails, (String)", ");
    }

    private String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        return CertUtil.getRDNValue(name, identifier);
    }
}

