/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.util;

import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA512tDigest;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class Fingerprint {
    private static char[] encodingTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] fingerprint;

    public Fingerprint(byte[] source) {
        this.fingerprint = Fingerprint.calculateFingerprint(source);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i != this.fingerprint.length; ++i) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(encodingTable[this.fingerprint[i] >>> 4 & 0xF]);
            sb.append(encodingTable[this.fingerprint[i] & 0xF]);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)o).fingerprint, this.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fingerprint);
    }

    public static byte[] calculateFingerprint(byte[] input) {
        SHA512tDigest digest = new SHA512tDigest(160);
        digest.update(input, 0, input.length);
        byte[] rv = new byte[digest.getDigestSize()];
        digest.doFinal(rv, 0);
        return rv;
    }
}

