/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.key.info;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.security.key.SnotifyPgpKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.gui.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.key.info.AKeyInfoBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;
import org.apache.commons.lang.StringUtils;

public class PgpKeyInfoBuilder
extends AKeyInfoBuilder {
    private final SnotifyPgpKey key;
    private final Long keyId;

    public PgpKeyInfoBuilder(SnotifyPgpKey key, Long keyId, ISnotifyI18n i18n) {
        super(i18n);
        this.key = key;
        this.keyId = keyId;
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
    }

    public PgpKeyInfoBuilder(byte[] key, long keyId, ISnotifyI18n i18n) throws IOException, PGPException {
        super(i18n);
        PGPPublicKeyRingCollection coll;
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
        this.keyId = keyId;
        try (InputStream decoderStream = PGPUtil.getDecoderStream(new ByteArrayInputStream(key));){
            coll = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        }
        SnotifyPgpKey publicKey = null;
        Iterator<PGPPublicKeyRing> iter = coll.getKeyRings();
        while (iter.hasNext()) {
            PGPPublicKeyRing ring = iter.next();
            if (ring.getPublicKey(keyId) == null) continue;
            publicKey = new SnotifyPgpKey(ring);
            break;
        }
        if (publicKey == null) {
            throw new PGPException("No public key found for ID: " + Long.toHexString(keyId).toUpperCase());
        }
        this.key = publicKey;
    }

    public String buildConfluenceHtml() {
        return this.buildHtml(AKeyInfoBuilder.AtlassianStyle.CONFLUENCE);
    }

    public String buildJiraHtml() {
        return this.buildHtml(AKeyInfoBuilder.AtlassianStyle.JIRA);
    }

    private String buildHtml(AKeyInfoBuilder.AtlassianStyle style) {
        PGPPublicKey encKey;
        StringBuilder builder = new StringBuilder(500);
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.type"), this.getI18n().getText("info-builder.pgp.type"), "type-pgp");
        if (this.getUser() != null && this.getUserProps() != null) {
            Long timeStamp = this.getUserProps().getLong("net.savignano.snotify.email.pgp.timeStamp", this.getUser());
            this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.uploadTime"), timeStamp == null ? "N/A" : new Date(timeStamp), "key-uploadTime");
            EncryptionKeySource keySource = this.getUserProps().getEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.class, this.getUser());
            this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.uploadBy"), keySource == null ? "N/A" : this.getI18n().getText("encryption-key-source." + keySource.name()), "key-uploadBy");
        }
        PGPPublicKey masterKey = this.key.getMasterKey();
        PGPPublicKey pGPPublicKey = encKey = this.keyId == null ? null : this.key.getKey(this.keyId);
        if (encKey == null && (encKey = this.key.getEncryptionKey()) == null) {
            encKey = masterKey;
        }
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.pgp.key.valid"), masterKey.getCreationTime(), "key-valid");
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.pgp.key.id"), PgpUtil.getPrettyId(masterKey), "key-id");
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.pgp.key.fingerprint"), this.getPrettyPrintFingerprint(masterKey.getFingerprint()), "key-fingerprint");
        if (encKey.getKeyID() != masterKey.getKeyID()) {
            this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.pgp.key.encKeyId"), PgpUtil.getPrettyId(encKey), "key-encryption");
        }
        Object expires = encKey.getValidSeconds() == 0L ? this.getI18n().getText("info-builder.pgp.key.expires.never") : new Date(encKey.getCreationTime().getTime() + encKey.getValidSeconds() * 1000L);
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.pgp.key.expires"), expires, "key-expires");
        ArrayList<String> users = new ArrayList<String>();
        Iterator<String> iter = masterKey.getUserIDs();
        while (iter.hasNext()) {
            users.add(iter.next());
        }
        this.buildHtmlEntry(style, builder, this.getI18n().getText("info-builder.pgp.key.users"), StringUtils.join(users, (String)", "), "key-users");
        return builder.toString();
    }

    private String getPrettyPrintFingerprint(byte[] fingerprint) {
        String full = Hex.toHexString(fingerprint).toUpperCase();
        StringBuilder builder = new StringBuilder(full.length() + full.length() / 4);
        int space = -1;
        for (char c : full.toCharArray()) {
            if (++space == 4) {
                builder.append(' ');
                space = 0;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

