/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.gui.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.IKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapVerification
implements IKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(LdapVerification.class);
    private final LdapConnector connector;
    private final ISnotifyI18n i18n;
    private String userName;

    public LdapVerification(LdapConnector connector, ISnotifyI18n i18n) {
        this(connector, i18n, null);
    }

    public LdapVerification(LdapConnector connector, ISnotifyI18n i18n, String userName) {
        this.connector = connector;
        this.i18n = i18n;
        this.setUserName(userName);
        if (connector == null) {
            throw new IllegalArgumentException("Connector must not be null.");
        }
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
    }

    @Override
    public List<VerificationStatus> verify() {
        log.debug("Using connector: {}", (Object)this.connector);
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        this.canConnect(statusList);
        return statusList;
    }

    private void canConnect(List<VerificationStatus> statusList) {
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        try {
            log.debug("Connecting to LDAP location: {}", (Object)this.connector.getLdapUrl());
            this.connector.connect();
        }
        catch (NamingException e) {
            log.error("Could not connect to LDAP location " + this.connector.getLdapUrl() + ". Error message: " + e.getMessage(), (Throwable)e);
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("ldap-verification.canConnect.exception.title");
            status.message = this.i18n.getText("ldap-verification.canConnect.exception.message", (Object)this.connector.getLdapUrl(), (Object)e.getMessage());
            return;
        }
        status.status = EVerificationStatus.SUCCESS;
        status.title = this.i18n.getText("ldap-verification.canConnect.success.title");
        status.message = this.i18n.getText("ldap-verification.canConnect.success.message", (Object)this.connector.getLdapUrl());
        this.findUser(statusList);
        this.connector.disconnect();
    }

    private void findUser(List<VerificationStatus> statusList) {
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (this.getUserName() == null) {
            log.debug("No user was given, so can't check if user can be found in LDAP.");
            status.status = EVerificationStatus.INFO;
            status.title = this.i18n.getText("ldap-verification.findUser.noUser.title");
            status.message = this.i18n.getText("ldap-verification.findUser.noUser.message");
            return;
        }
        DirContext context = this.connector.getContext();
        String user = this.connector.getUserNameKey() + "=" + this.getUserName() + "," + this.connector.getUserBase();
        try {
            log.debug("Looking up user at: {}", (Object)user);
            context.lookup(user);
        }
        catch (NamingException e) {
            log.error("Could not look up user " + this.getUserName() + " at LDAP location " + this.connector.getLdapUrl() + ". Error message: " + e.getMessage(), (Throwable)e);
            status.status = EVerificationStatus.WARNING;
            status.title = this.i18n.getText("ldap-verification.findUser.exception.title");
            status.message = this.i18n.getText("ldap-verification.findUser.exception.message", (Object)this.getUserName());
            return;
        }
        status.status = EVerificationStatus.SUCCESS;
        status.title = this.i18n.getText("ldap-verification.findUser.success.title");
        status.message = this.i18n.getText("ldap-verification.findUser.success.message", (Object)this.getUserName());
    }

    public LdapConnector getConnector() {
        return this.connector;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

