/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.savignano.snotify.atlassian.common.util.CertUtil;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.gui.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.IKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeKeyStoreVerification
implements IKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeKeyStoreVerification.class);
    private final ISnotifyI18n i18n;
    private final String location;
    private String email;

    public SmimeKeyStoreVerification(String location, ISnotifyI18n i18n) {
        this(location, null, i18n);
    }

    public SmimeKeyStoreVerification(String location, String email, ISnotifyI18n i18n) {
        this.location = location;
        this.email = email;
        this.i18n = i18n;
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
    }

    @Override
    public List<VerificationStatus> verify() {
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        this.canReadLocation(statusList);
        return statusList;
    }

    private void canReadLocation(List<VerificationStatus> statusList) {
        SecurityException e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (SecurityException e1) {
            e = e1;
            log.warn("Can not access keystore location: " + this.location, (Throwable)e);
        }
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (canRead) {
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("smime-keystore-verification.canRead.success.title");
            status.message = this.i18n.getText("smime-keystore-verification.canRead.success.message", (Object)this.location);
            this.loadKeyStore(statusList);
        } else if (e != null) {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.canRead.exception.title");
            status.message = this.i18n.getText("smime-keystore-verification.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
        } else {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.canRead.failure.title");
            status.message = this.i18n.getText("smime-keystore-verification.canRead.failure.message", (Object)this.location);
        }
    }

    private void loadKeyStore(List<VerificationStatus> statusList) {
        Provider provider = SecurityUtil.getProvider();
        Exception e = null;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("BKS", provider);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.location));){
                ks.load(in, null);
                log.debug("Could load key store from location: {}", (Object)this.location);
            }
        }
        catch (Exception e1) {
            e = e1;
            log.warn("Could not load key store from location: " + this.location, (Throwable)e);
        }
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (e == null) {
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("smime-keystore-verification.loadKeyStore.success.title");
            status.message = this.i18n.getText("smime-keystore-verification.loadKeyStore.success.message");
            this.checkEmail(statusList, ks);
        } else {
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.loadKeyStore.exception.title");
            status.message = this.i18n.getText("smime-keystore-verification.loadKeyStore.exception.message", (Object)e.getClass().getSimpleName(), (Object)e.getLocalizedMessage());
        }
    }

    private void checkEmail(List<VerificationStatus> statusList, KeyStore keyStore) {
        X509Certificate cert;
        if (keyStore == null) {
            return;
        }
        VerificationStatus status = new VerificationStatus();
        statusList.add(status);
        if (this.email == null) {
            log.debug("No email address was given, so can't check if a certificate was found for it.");
            status.status = EVerificationStatus.INFO;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.noEmail.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.noEmail.message");
            return;
        }
        try {
            cert = CertUtil.getCertForEmail(keyStore, this.email);
        }
        catch (KeyStoreException | CertificateException e) {
            log.debug("Could not look up email " + this.email + " in keystore \"" + keyStore + "\".", (Throwable)e);
            status.status = EVerificationStatus.ERROR;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.exception.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.exception.message", (Object)this.email);
            return;
        }
        if (cert != null) {
            log.debug("Certificate for email {} was found in key store.", (Object)this.email);
            status.status = EVerificationStatus.SUCCESS;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.success.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.success.message", (Object)this.email);
        } else {
            log.debug("No certificate for email {} was found in key store.", (Object)this.email);
            status.status = EVerificationStatus.WARNING;
            status.title = this.i18n.getText("smime-keystore-verification.checkEmail.failure.title");
            status.message = this.i18n.getText("smime-keystore-verification.checkEmail.failure.message", (Object)this.email);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

