/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUser;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.ConfigurationException;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.LdapVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.PgpKeyServerVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.confluence.gui.SnotifyAppProperties;
import net.savignano.snotify.confluence.gui.SnotifyI18n;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyKeystoreSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -3672832928332627619L;
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private static final String KEYSTORE_LOCATION_PARAM = "keystore";
    private static final String KEYSERVER_LOCATION_PARAM = "keyserver";
    private static final String EXPIRE_KEYS_PARAM = "expireKeys";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PARAM = "allowPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_PARAM = "allowSmimeCertOverwrite";
    private static final String USE_LDAP_SMIME_CERTIFICATE_PARAM = "useLdapSmime";
    private static final String VERIFY_BUTTON_PARAM = "Test settings";
    private static final Logger log = LoggerFactory.getLogger(SnotifyKeystoreSettingsAction.class);
    private final ISnotifyAppProperties appProps = new SnotifyAppProperties();
    private String keyserverLocation;
    private String keystoreLocation;
    private String verifyMessage;
    private boolean expireKeys;
    private boolean allowSmimeOverwrite;
    private boolean allowPgpOverwrite;
    private boolean useLdapSmime;
    private boolean showUpdated;

    public String doInput() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        if (this.keystoreLocation == null) {
            this.readProps();
        }
        return "input";
    }

    public String doSubmit() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.readParams();
        if (this.getCurrentRequest().getParameter(VERIFY_BUTTON_PARAM) != null) {
            return this.verifySettings();
        }
        return this.storeSettings();
    }

    private String storeSettings() {
        this.storeProps();
        this.showUpdated = true;
        return "success";
    }

    private String verifySettings() {
        this.expireKeys = false;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        if (this.keystoreLocation != null && !this.keystoreLocation.isEmpty()) {
            statusList.addAll(this.verifyKeystore());
        }
        if (this.keyserverLocation != null && !this.keyserverLocation.isEmpty()) {
            statusList.addAll(this.verifyKeyserver());
        }
        if (this.useLdapSmime) {
            statusList.addAll(this.verifyLdap());
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        this.verifyMessage = builder.toString();
        return "input";
    }

    private List<VerificationStatus> verifyKeystore() {
        log.info("Verifying key store at location: {}", (Object)this.keystoreLocation);
        String email = this.getAuthenticatedUser().getEmail();
        SnotifyI18n i18n = new SnotifyI18n(this.getI18n());
        SmimeKeyStoreVerification verification = new SmimeKeyStoreVerification(this.keystoreLocation, email, i18n);
        return verification.verify();
    }

    private List<VerificationStatus> verifyKeyserver() {
        log.info("Verifying PGP key server at location: {}", (Object)this.keyserverLocation);
        String email = this.getAuthenticatedUser().getEmail();
        SnotifyI18n i18n = new SnotifyI18n(this.getI18n());
        PgpKeyServerVerification verification = new PgpKeyServerVerification(this.keyserverLocation, email, i18n);
        return verification.verify();
    }

    private List<VerificationStatus> verifyLdap() {
        Directory directory;
        log.info("Verifying LDAP server.");
        SnotifyI18n i18n = new SnotifyI18n(this.getI18n());
        EmbeddedCrowdUser user = this.getCrowdUser((User)this.getAuthenticatedUser());
        if (user == null) {
            log.debug("Could not find a crowd user for user: {}", (Object)this.getAuthenticatedUser());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirUserNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirUserNotFound.message", (Object)this.getAuthenticatedUser());
            return Collections.singletonList(status);
        }
        long directoryId = user.getDirectoryId();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with ID " + directoryId + ". Error message: " + e.getMessage(), (Throwable)e);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirNotFound.message", (Object)directoryId, (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        if (!LdapConnector.isConnector(directory)) {
            log.debug("Directory {} is probably not an LDAP directory.", (Object)directory.getName());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirNotLdap.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirNotLdap.message", (Object)directory.getName(), (Object)userName);
            return Collections.singletonList(status);
        }
        try {
            LdapConnector connector = LdapConnector.createConnector(directory);
            LdapVerification verification = new LdapVerification(connector, i18n, userName);
            return verification.verify();
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP from directory " + directory.getName() + ". Error message: " + e.getMessage());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirError.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.ldap.verification.dirError.message", (Object)e.getMessage());
            return Collections.singletonList(status);
        }
    }

    private EmbeddedCrowdUser getCrowdUser(User user) {
        if (user instanceof EmbeddedCrowdUser) {
            return (EmbeddedCrowdUser)user;
        }
        if (user instanceof ConfluenceUserImpl) {
            return this.getCrowdUser(((ConfluenceUserImpl)user).getBackingUser());
        }
        return null;
    }

    public String getCheckedSmimeOverwrite() {
        return this.allowSmimeOverwrite ? CHECKBOX_CHECKED : "";
    }

    public String getCheckedPgpOverwrite() {
        return this.allowPgpOverwrite ? CHECKBOX_CHECKED : "";
    }

    public String getCheckedLdapSmime() {
        return this.useLdapSmime ? CHECKBOX_CHECKED : "";
    }

    public boolean isShowUpdateInfo() {
        return this.showUpdated;
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    public boolean isDisabled() {
        return this.appProps.getBoolean("net.savignano.snotify.mailer.disable");
    }

    public boolean isFrozen() {
        return this.appProps.getBoolean("net.savignano.snotify.mailer.freeze");
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }

    public String getKeyserverLocation() {
        return this.keyserverLocation == null ? "" : this.keyserverLocation;
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation == null ? "" : this.keystoreLocation;
    }

    private void readParams() {
        this.keyserverLocation = this.getCurrentRequest().getParameter(KEYSERVER_LOCATION_PARAM);
        this.keystoreLocation = this.getCurrentRequest().getParameter(KEYSTORE_LOCATION_PARAM);
        this.expireKeys = Boolean.parseBoolean(this.getCurrentRequest().getParameter(EXPIRE_KEYS_PARAM));
        this.allowSmimeOverwrite = Boolean.parseBoolean(this.getCurrentRequest().getParameter(ALLOW_SMIME_CERTIFICATE_OVERWRITE_PARAM));
        this.allowPgpOverwrite = Boolean.parseBoolean(this.getCurrentRequest().getParameter(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_PARAM));
        this.useLdapSmime = Boolean.parseBoolean(this.getCurrentRequest().getParameter(USE_LDAP_SMIME_CERTIFICATE_PARAM));
    }

    private void storeProps() {
        boolean locationChanged = this.isLocationChanged();
        this.appProps.setString("net.savignano.snotify.pgp.keyserverLocation", this.keyserverLocation);
        this.appProps.setString("net.savignano.snotify.smime.keystoreLocation", this.keystoreLocation);
        this.appProps.setBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", this.allowSmimeOverwrite);
        this.appProps.setBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", this.allowPgpOverwrite);
        this.appProps.setBoolean("net.savignano.snotify.ldap.smime.query", this.useLdapSmime);
        if (this.expireKeys || locationChanged) {
            this.appProps.setLong("net.savignano.snotify.mailer.expireKeys.timeStamp", System.currentTimeMillis());
        }
    }

    private void readProps() {
        this.keyserverLocation = this.appProps.getString("net.savignano.snotify.pgp.keyserverLocation");
        this.keystoreLocation = this.appProps.getString("net.savignano.snotify.smime.keystoreLocation");
        this.allowSmimeOverwrite = this.appProps.getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        this.allowPgpOverwrite = this.appProps.getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
        this.useLdapSmime = this.appProps.getBoolean("net.savignano.snotify.ldap.smime.query");
    }

    private boolean isLocationChanged() {
        String oldKeystoreLocation = this.appProps.getString("net.savignano.snotify.smime.keystoreLocation");
        if (!StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldKeystoreLocation), (String)StringUtils.stripToNull((String)this.keystoreLocation))) {
            return true;
        }
        String oldKeyserverLocation = this.appProps.getString("net.savignano.snotify.pgp.keyserverLocation");
        return !StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldKeyserverLocation), (String)StringUtils.stripToNull((String)this.keyserverLocation));
    }
}

