/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.enums.EncryptionKeySource;
import net.savignano.snotify.atlassian.common.enums.EncryptionTypePriorityOption;
import net.savignano.snotify.atlassian.common.security.key.SnotifyPgpKey;
import net.savignano.snotify.atlassian.common.util.CertUtil;
import net.savignano.snotify.atlassian.gui.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.key.info.PgpKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.SmimeCertInfoBuilder;
import net.savignano.snotify.confluence.gui.ConfluenceUser;
import net.savignano.snotify.confluence.gui.SnotifyAppProperties;
import net.savignano.snotify.confluence.gui.SnotifyI18n;
import net.savignano.snotify.confluence.gui.SnotifyUserProperties;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyUserSettingsAction
extends AbstractUserProfileAction {
    private static final long serialVersionUID = -5462548019091147432L;
    private static final String ERROR_EMAIL_MISMATCH = "error-email";
    private static final String ERROR_EXPIRED = "error-expired";
    private static final String ERROR_KEYNOTFOUND = "error-keynotfound";
    private static final String ERROR_NOTYETVALID = "error-notyetvalid";
    private static final String ERROR_PGP = "error-pgp";
    private static final String ERROR_SMIME = "error-smime";
    private static final String FILE_PARAM = "file";
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserSettingsAction.class);
    private final ISnotifyAppProperties appProps = new SnotifyAppProperties();
    private final ISnotifyUserProperties userProps = new SnotifyUserProperties();
    private Exception lastException;
    private EncryptionTypePriorityOption typePriority;
    private EncryptionTypePriorityOption lastUpload;
    private Boolean allowSmimeUpload;
    private Boolean allowPgpUpload;

    public String doInput() {
        com.atlassian.confluence.user.ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        this.lastUpload = null;
        return "input";
    }

    public String doSubmitSmime() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        com.atlassian.confluence.user.ConfluenceUser authUser = this.getAuthenticatedUser();
        if (authUser == null) {
            log.warn("User is not authenticated for uploading custom S/MIME certificate.");
            return null;
        }
        if (!this.isAllowSmimeUpload()) {
            log.warn("Uploading of custom S/MIME certificate is not allowed. User: {}", (Object)authUser);
            return this.doInput();
        }
        this.lastUpload = EncryptionTypePriorityOption.SMIME_ONLY;
        MultiPartRequestWrapper requestWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        if (requestWrapper.hasErrors()) {
            Collection errors = requestWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                this.addActionError((String)i.next());
            }
            return "error";
        }
        File certFile = null;
        File[] files = requestWrapper.getFiles(FILE_PARAM);
        if (files != null && files.length > 0) {
            certFile = files[0];
        }
        ConfluenceUser user = new ConfluenceUser((User)authUser);
        try {
            byte[] cert = certFile != null ? Files.readAllBytes(certFile.toPath()) : null;
            this.setEmailCert(cert, user);
            return "success";
        }
        catch (EmailException e) {
            this.lastException = e;
            log.info("Email address mismatch.", (Throwable)e);
            return ERROR_EMAIL_MISMATCH;
        }
        catch (CertificateExpiredException e) {
            this.lastException = e;
            log.info("Certificate expired.", (Throwable)e);
            return ERROR_EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            this.lastException = e;
            log.info("Certificate not yet valid.", (Throwable)e);
            return ERROR_NOTYETVALID;
        }
        catch (IOException | CertificateException e) {
            this.lastException = e;
            log.info("Certificate parsing failed.", (Throwable)e);
            return ERROR_SMIME;
        }
    }

    public String doSubmitPgp() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        com.atlassian.confluence.user.ConfluenceUser authUser = this.getAuthenticatedUser();
        if (authUser == null) {
            log.warn("User is not authenticated for uploading custom PGP key.");
            return null;
        }
        if (!this.isAllowPgpUpload()) {
            log.warn("Uploading of custom PGP key is not allowed. User: {}", (Object)authUser);
            return null;
        }
        this.lastUpload = EncryptionTypePriorityOption.PGP_ONLY;
        MultiPartRequestWrapper requestWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        if (requestWrapper.hasErrors()) {
            Collection errors = requestWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                this.addActionError((String)i.next());
            }
            return "error";
        }
        File keyFile = null;
        File[] files = requestWrapper.getFiles(FILE_PARAM);
        if (files != null && files.length > 0) {
            keyFile = files[0];
        }
        ConfluenceUser user = new ConfluenceUser((User)authUser);
        try {
            byte[] key = keyFile != null ? Files.readAllBytes(keyFile.toPath()) : null;
            this.setEmailPgpKey(key, user);
            return "success";
        }
        catch (IOException | PGPException e) {
            this.lastException = e;
            log.info("Key parsing failed.", (Throwable)e);
            return ERROR_PGP;
        }
        catch (KeyException e) {
            this.lastException = e;
            log.info("No valid key found.", (Throwable)e);
            return ERROR_KEYNOTFOUND;
        }
    }

    private void setEmailCert(byte[] cert, ConfluenceUser user) throws CertificateException {
        if (cert == null || cert.length == 0) {
            log.debug("Clearing certificate for user: " + user.getDisplayName());
            this.userProps.setBytes("net.savignano.snotify.email.smime.cert", null, user);
            this.userProps.setLong("net.savignano.snotify.email.smime.timeStamp", null, user);
            this.userProps.setEnum("net.savignano.snotify.email.smime.keySource", null, user);
        } else {
            log.debug("Checking certificate for user: " + user.getDisplayName());
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
            certificate.checkValidity();
            String certEmail = StringUtils.join((Object[])CertUtil.getEmails(certificate), (String)", ").toLowerCase();
            if (!certEmail.contains(user.getEmail().toLowerCase())) {
                throw new EmailException(certEmail, user.getDisplayName());
            }
            log.debug("Setting certificate for user: " + user.getDisplayName());
            this.userProps.setBytes("net.savignano.snotify.email.smime.cert", cert, user);
            this.userProps.setLong("net.savignano.snotify.email.smime.timeStamp", System.currentTimeMillis(), user);
            this.userProps.setEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.USER, user);
        }
    }

    private void setEmailPgpKey(byte[] key, ConfluenceUser user) throws IOException, PGPException, KeyException {
        if (key == null || key.length == 0) {
            log.info("Clearing PGP key for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes("net.savignano.snotify.email.pgp.key", null, user);
            this.userProps.setLong("net.savignano.snotify.email.pgp.key.id", null, user);
            this.userProps.setLong("net.savignano.snotify.email.pgp.timeStamp", null, user);
            this.userProps.setEnum("net.savignano.snotify.email.pgp.keySource", null, user);
        } else {
            SnotifyPgpKey usedKey;
            log.debug("Checking PGP key for user: {}", (Object)user.getDisplayName());
            String userEmailAddress = user.getEmail().toLowerCase();
            try (InputStream decoderStream = PGPUtil.getDecoderStream(new ByteArrayInputStream(key));){
                PGPPublicKeyRingCollection keyRings = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                usedKey = new SnotifyPgpKey(keyRings, userEmailAddress);
            }
            PGPPublicKey encKey = usedKey.getEncryptionKey();
            if (encKey == null) {
                throw new KeyException("Could not find a valid encryption key.");
            }
            log.info("Setting PGP key for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes("net.savignano.snotify.email.pgp.key", key, user);
            this.userProps.setLong("net.savignano.snotify.email.pgp.key.id", encKey.getKeyID(), user);
            this.userProps.setLong("net.savignano.snotify.email.pgp.timeStamp", System.currentTimeMillis(), user);
            this.userProps.setEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.USER, user);
        }
    }

    private String buildCertInfo(byte[] cert, ConfluenceUser user) throws CertificateException {
        SmimeCertInfoBuilder builder = new SmimeCertInfoBuilder(cert, (ISnotifyI18n)new SnotifyI18n(this.getI18n()));
        builder.setUser(user);
        builder.setUserProps(this.userProps);
        return builder.buildConfluenceHtml();
    }

    private String buildKeyInfo(byte[] key, long keyId, ConfluenceUser user) throws IOException, PGPException {
        PgpKeyInfoBuilder builder = new PgpKeyInfoBuilder(key, keyId, (ISnotifyI18n)new SnotifyI18n(this.getI18n()));
        builder.setUser(user);
        builder.setUserProps(this.userProps);
        return builder.buildConfluenceHtml();
    }

    public String getErrorMessage() {
        return this.lastException == null ? null : this.lastException.getMessage();
    }

    @HtmlSafe
    public String getCertDetails() {
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        Object cert = this.appProps.getBoolean("net.savignano.snotify.lite.mode") && this.userProps.getEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.class, user) != EncryptionKeySource.USER ? null : this.userProps.getBytes("net.savignano.snotify.email.smime.cert", user);
        String info = null;
        if (cert == null) {
            info = this.getText("snotify-user-settings-item.input.smime.notfound");
            log.debug("No certificate specified for user: {}", (Object)user.getDisplayName());
        } else {
            try {
                info = this.buildCertInfo((byte[])cert, user);
                log.debug("Certificate information for user {}: {}", (Object)user.getDisplayName(), (Object)info);
            }
            catch (CertificateException e) {
                log.warn("Could not load public certificate for user: " + user.getDisplayName(), (Throwable)e);
                info = this.getText("snotify-user-settings-item.input.smime.error", new String[]{e.getLocalizedMessage()});
            }
        }
        return info;
    }

    @HtmlSafe
    public String getPgpDetails() {
        Long keyId;
        byte[] key;
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        if (this.appProps.getBoolean("net.savignano.snotify.lite.mode") && this.userProps.getEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.class, user) != EncryptionKeySource.USER) {
            key = null;
            keyId = null;
        } else {
            key = this.userProps.getBytes("net.savignano.snotify.email.pgp.key", user);
            keyId = this.userProps.getLong("net.savignano.snotify.email.pgp.key.id", user);
        }
        String info = null;
        if (key == null || keyId == null) {
            info = this.getText("snotify-user-settings-item.input.pgp.notfound");
            log.debug("No certificate specified for user: {}", (Object)user.getDisplayName());
        } else {
            try {
                info = this.buildKeyInfo(key, keyId, user);
                log.debug("Key information for user {}: {}", (Object)user.getDisplayName(), (Object)info);
            }
            catch (IOException | PGPException e) {
                log.warn("Could not load PGP key for user: " + user.getDisplayName(), (Throwable)e);
                info = this.getText("snotify-user-settings-item.input.pgp.error", e.getLocalizedMessage());
            }
        }
        return info;
    }

    public boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERED: 
            case PGP_PREFERED: {
                return true;
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isSmimeSelected() {
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERED: {
                return this.lastUpload != EncryptionTypePriorityOption.PGP_ONLY;
            }
            case PGP_PREFERED: {
                return this.lastUpload == EncryptionTypePriorityOption.SMIME_ONLY;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isPgpSelected() {
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERED: {
                return this.lastUpload == EncryptionTypePriorityOption.PGP_ONLY;
            }
            case PGP_PREFERED: {
                return this.lastUpload != EncryptionTypePriorityOption.SMIME_ONLY;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    public boolean isSmimeUploadAllowed() {
        return this.isAllowSmimeUpload();
    }

    public boolean isPgpUploadAllowed() {
        return this.isAllowPgpUpload();
    }

    private EncryptionTypePriorityOption getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.appProps.getEnum("net.savignano.snotify.mailer.encryptionTypePriority", EncryptionTypePriorityOption.class);
            if (this.typePriority == null) {
                this.typePriority = EncryptionTypePriorityOption.SMIME_PREFERED;
            }
        }
        return this.typePriority;
    }

    private boolean isAllowSmimeUpload() {
        if (this.allowSmimeUpload == null) {
            this.allowSmimeUpload = this.appProps.getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true) || this.appProps.getBoolean("net.savignano.snotify.lite.mode");
        }
        return this.allowSmimeUpload;
    }

    private boolean isAllowPgpUpload() {
        if (this.allowPgpUpload == null) {
            this.allowPgpUpload = this.appProps.getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true) || this.appProps.getBoolean("net.savignano.snotify.lite.mode");
        }
        return this.allowPgpUpload;
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = -5262905856665194L;

        private EmailException(String email, String user) {
            super("Email address(es) of certificate (" + email + ") do not match email of user: " + user);
        }
    }
}

