/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jce.provider;

import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.savignano.thirdparty.org.bouncycastle.jcajce.PKIXCRLStoreSelector;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.AnnotatedException;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import net.savignano.thirdparty.org.bouncycastle.util.StoreException;

class PKIXCRLUtil {
    PKIXCRLUtil() {
    }

    public Set findCRLs(PKIXCRLStoreSelector crlselect, Date validityDate, List certStores, List pkixCrlStores) throws AnnotatedException {
        HashSet initialSet = new HashSet();
        try {
            initialSet.addAll(this.findCRLs(crlselect, pkixCrlStores));
            initialSet.addAll(this.findCRLs(crlselect, certStores));
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", e);
        }
        HashSet<X509CRL> finalSet = new HashSet<X509CRL>();
        for (X509CRL crl : initialSet) {
            if (!crl.getNextUpdate().after(validityDate)) continue;
            X509Certificate cert = crlselect.getCertificateChecking();
            if (cert != null) {
                if (!crl.getThisUpdate().before(cert.getNotAfter())) continue;
                finalSet.add(crl);
                continue;
            }
            finalSet.add(crl);
        }
        return finalSet;
    }

    private final Collection findCRLs(PKIXCRLStoreSelector crlSelect, List crlStores) throws AnnotatedException {
        HashSet<Object> crls = new HashSet<Object>();
        Iterator iter = crlStores.iterator();
        AnnotatedException lastException = null;
        boolean foundValidStore = false;
        while (iter.hasNext()) {
            Object store;
            Object obj = iter.next();
            if (obj instanceof Store) {
                store = (Store)obj;
                try {
                    crls.addAll(store.getMatches(crlSelect));
                    foundValidStore = true;
                }
                catch (StoreException e) {
                    lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
                }
                continue;
            }
            store = (CertStore)obj;
            try {
                crls.addAll(PKIXCRLStoreSelector.getCRLs(crlSelect, (CertStore)store));
                foundValidStore = true;
            }
            catch (CertStoreException e) {
                lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
            }
        }
        if (!foundValidStore && lastException != null) {
            throw lastException;
        }
        return crls;
    }
}

