/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.McElieceKeyGenParameterSpec;

public class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    McElieceKeyPairGenerator kpg;

    public McElieceKeyPairGeneratorSpi() {
        super("McEliece");
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceKeyPairGenerator();
        super.initialize(params);
        McElieceKeyGenParameterSpec ecc = (McElieceKeyGenParameterSpec)params;
        McElieceKeyGenerationParameters mccKGParams = new McElieceKeyGenerationParameters(new SecureRandom(), new McElieceParameters(ecc.getM(), ecc.getT()));
        this.kpg.init(mccKGParams);
    }

    public void initialize(int keySize, SecureRandom random) {
        McElieceKeyGenParameterSpec paramSpec = new McElieceKeyGenParameterSpec();
        try {
            this.initialize(paramSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair generateKeyPair = this.kpg.generateKeyPair();
        McEliecePrivateKeyParameters sk = (McEliecePrivateKeyParameters)generateKeyPair.getPrivate();
        McEliecePublicKeyParameters pk = (McEliecePublicKeyParameters)generateKeyPair.getPublic();
        return new KeyPair(new BCMcEliecePublicKey(pk), new BCMcEliecePrivateKey(sk));
    }
}

