/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key.secret;

import java.util.Arrays;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.secret.ISnotifySecretKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPgpDecryptionKey
extends ASnotifyKey<PGPSecretKeyRingCollection>
implements ISnotifySecretKey<PGPSecretKeyRingCollection> {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPgpDecryptionKey.class);
    private PGPSecretKeyRingCollection secret;
    private char[] password;

    public SnotifyPgpDecryptionKey(PGPSecretKeyRingCollection secret, char[] password) {
        super(EKeyPurpose.DECRYPTION);
        this.secret = secret;
        if (password != null) {
            this.password = Arrays.copyOf(password, password.length);
        } else {
            log.warn("Password was <null>. If secret key does indeed have no password, this is a security problem, as anyone can use it.");
        }
        if (secret == null) {
            log.warn("Secret key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SnotifyPgpDecryptionKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SnotifyPgpDecryptionKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.DECRYPTION);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public PGPSecretKeyRingCollection getKey() {
        return this.secret;
    }

    public char[] getPassword() {
        return this.password;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.secret = null;
        SecurityUtil.clearPassword(this.password);
        this.password = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.secret == null && this.password == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("PGP Decryption Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Password: ");
        builder.append(this.getPassword() == null ? "<null>" : "*****");
        return builder.toString();
    }
}

