/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key.secret;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.secret.ISnotifySecretKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPgpSignKey
extends ASnotifyKey<PGPSecretKey>
implements ISnotifySecretKey<PGPSecretKey> {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPgpSignKey.class);
    private PGPSecretKeyRing ring;
    private PGPSecretKey masterKey;
    private PGPSecretKey signingKey;
    private char[] password;

    private static PGPSecretKey findSigningKey(PGPSecretKeyRing ring) {
        ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>();
        for (PGPSecretKey key : ring) {
            if (!SnotifyPgpSignKey.isValidSigningKey(key)) continue;
            keys.add(key);
        }
        PGPSecretKey newestKey = null;
        for (PGPSecretKey key : keys) {
            if (newestKey != null && !newestKey.getPublicKey().getCreationTime().before(key.getPublicKey().getCreationTime())) continue;
            newestKey = key;
        }
        if (log.isDebugEnabled()) {
            if (newestKey == null) {
                log.debug("No key found that can be used for singing. Master key ID: {}", (Object)PgpUtil.getPrettyId(ring.getSecretKey()));
            } else {
                log.debug("Using key with ID {}. Creation time: {}", (Object)Long.toHexString(newestKey.getKeyID()).toUpperCase(), (Object)newestKey.getPublicKey().getCreationTime());
            }
        }
        return newestKey;
    }

    private static boolean isValidSigningKey(PGPSecretKey key) {
        boolean valid;
        String prettyKeyId = PgpUtil.getPrettyId(key);
        if (!key.isSigningKey()) {
            log.debug("Algorithm for key with ID {} can not be used for encryption.", (Object)prettyKeyId);
            return false;
        }
        boolean keyFlagsUsed = false;
        boolean signingFlag = false;
        Iterator signatures = key.getPublicKey().getSignatures();
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
            if (packets == null) continue;
            int keyFlags = packets.getKeyFlags();
            boolean bl = keyFlagsUsed = keyFlagsUsed || keyFlags != 0;
            if ((keyFlags & 2) == 0) continue;
            signingFlag = true;
            break;
        }
        if (!signingFlag && keyFlagsUsed) {
            log.debug("Key with ID {} has not the necessary flags for a signing key.", (Object)prettyKeyId);
            return false;
        }
        if (key.getPublicKey().hasRevocation()) {
            log.warn("Key with ID {} has been revoked.", (Object)prettyKeyId);
            return false;
        }
        long validSeconds = key.getPublicKey().getValidSeconds();
        boolean bl = valid = validSeconds == 0L || validSeconds * 1000L + key.getPublicKey().getCreationTime().getTime() >= System.currentTimeMillis();
        if (!valid) {
            log.warn("Key with ID {} is no loger valid. Expired: {}", (Object)prettyKeyId, (Object)new Date(validSeconds * 1000L + key.getPublicKey().getCreationTime().getTime()));
            return false;
        }
        log.debug("Key with ID {} can be used for signing.", (Object)prettyKeyId);
        return true;
    }

    public SnotifyPgpSignKey(PGPSecretKeyRingCollection collection, char[] password, String email) {
        super(EKeyPurpose.SIGNING);
        if (collection == null) {
            log.warn("Key ring collection was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (email == null) {
            log.warn("Email address was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        log.debug("Looking up key ring for email <{}>.", (Object)email);
        PGPSecretKeyRing matchedRing = null;
        PGPSecretKey matchedMasterKey = null;
        Iterator<PGPSecretKeyRing> iterRing = collection.iterator();
        while (iterRing.hasNext() && matchedRing == null) {
            PGPSecretKeyRing ring = iterRing.next();
            PGPSecretKey key = ring.getSecretKey();
            if (key == null || !key.isMasterKey()) {
                log.warn("Passed key ring collection contains a ring without a corresponding master key. Maybe key ring is corrupt.");
                continue;
            }
            if (PgpUtil.isKeyForEmail(key, email)) {
                log.debug("Master key (ID: {}) is valid for email <{}>.", (Object)PgpUtil.getPrettyId(key), (Object)email);
                matchedRing = ring;
                matchedMasterKey = key;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            ArrayList<String> ids = new ArrayList<String>();
            Iterator<String> iter = key.getUserIDs();
            while (iter.hasNext()) {
                ids.add(iter.next());
            }
            String prettyKeyId = PgpUtil.getPrettyId(key);
            if (ids.isEmpty()) {
                log.debug("Key with ID {} does not contain any user IDs.", (Object)prettyKeyId);
                continue;
            }
            log.debug("Key with ID {} does not match email <{}>. It has the following user IDs: {}", new Object[]{prettyKeyId, email, ids});
        }
        if (matchedRing != null) {
            this.ring = matchedRing;
            this.masterKey = matchedMasterKey;
            this.signingKey = SnotifyPgpSignKey.findSigningKey(matchedRing);
            if (this.signingKey != null) {
                this.checkPassword(this.signingKey, password);
            } else {
                log.warn("No valid signing key was found to sign emails. Corresponding master key ID: {}", (Object)PgpUtil.getPrettyId(this.masterKey));
                this.setKeyValidity(EKeyValidity.NOT_FOUND);
            }
        } else {
            log.warn("No matching key ring found for email address: <{}>", (Object)email);
            this.setKeyValidity(EKeyValidity.NOT_FOUND);
        }
    }

    public SnotifyPgpSignKey(PGPSecretKeyRing ring, char[] password) {
        this(ring, password, null);
    }

    public SnotifyPgpSignKey(PGPSecretKeyRing ring, char[] password, String email) {
        super(EKeyPurpose.SIGNING);
        if (ring == null) {
            log.warn("Key ring was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        this.ring = ring;
        this.masterKey = ring.getSecretKey();
        this.signingKey = SnotifyPgpSignKey.findSigningKey(ring);
        if (this.masterKey == null || !this.masterKey.isMasterKey()) {
            log.warn("Passed key ring has no master key. Maybe key ring is corrupt.");
            this.setKeyValidity(EKeyValidity.INVALID);
        } else if (this.signingKey == null) {
            log.warn("No valid signing key was found to sign emails. Corresponding master key ID: {}", (Object)PgpUtil.getPrettyId(this.masterKey));
            this.setKeyValidity(EKeyValidity.INVALID);
        } else if (email != null && !PgpUtil.isKeyForEmail(this.masterKey, email)) {
            log.warn("Key ring is no match for email address: <{}>", (Object)email);
            this.setKeyValidity(EKeyValidity.INVALID);
        } else {
            this.checkPassword(this.signingKey, password);
        }
    }

    private void checkPassword(PGPSecretKey key, char[] password) {
        try {
            PgpUtil.extractPrivateKey(key, password);
            if (password != null) {
                this.password = Arrays.copyOf(password, password.length);
            } else {
                log.warn("Password was <null>. If secret key does indeed have no password, this is a security problem, as anyone can use it.");
            }
        }
        catch (PGPException e) {
            if ("checksum mismatch at 0 of 20".equals(e.getMessage())) {
                log.error("Supplied password was wrong to extract private key from key with ID: " + PgpUtil.getPrettyId(this.signingKey), (Throwable)e);
                this.setKeyValidity(EKeyValidity.INVALID);
            }
            if (password == null && e.getCause() instanceof NullPointerException) {
                log.error("No password given to extract private key from key with ID: " + PgpUtil.getPrettyId(this.signingKey));
                this.setKeyValidity(EKeyValidity.INVALID);
            }
            log.error("Error while extracting private key with ID: " + PgpUtil.getPrettyId(this.signingKey), (Throwable)e);
            this.setKeyValidity(EKeyValidity.ERROR);
        }
    }

    public SnotifyPgpSignKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SnotifyPgpSignKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.SIGNING);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    public PGPSecretKeyRing getKeyRing() {
        return this.ring;
    }

    public PGPSecretKey getMasterKey() {
        return this.masterKey;
    }

    @Override
    public PGPSecretKey getKey() {
        return this.signingKey;
    }

    public char[] getPassword() {
        return this.password;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.masterKey = null;
        this.signingKey = null;
        SecurityUtil.clearPassword(this.password);
        this.password = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.masterKey == null && this.signingKey == null && this.password == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("PGP Sign Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Signing Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getKey()));
        builder.append("; Master Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getMasterKey()));
        builder.append("; Password: ");
        builder.append(this.getPassword() == null ? "<null>" : "*****");
        return builder.toString();
    }
}

