/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.IVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerVersion
implements IVersion {
    private static final Logger log = LoggerFactory.getLogger(MailerVersion.class);
    private static String version;
    private final SMTPMailServer server;
    private final ISnotifyAppProperties appProps;

    public MailerVersion(SMTPMailServer server, ISnotifyAppProperties appProps) {
        this.server = server;
        this.appProps = appProps;
        if (server == null) {
            throw new IllegalArgumentException("Server must not be null.");
        }
        if (appProps == null) {
            throw new IllegalArgumentException("Application Properties must not be null.");
        }
    }

    @Override
    public String getVersion() {
        if (version == null) {
            version = this.getMailerVersion();
        }
        return version;
    }

    private String getMailerVersion() {
        this.appProps.setString(EProperty.MAILER_VERSION, null);
        Email email = this.createEmail();
        try {
            log.debug("Sending internal email to check S/Notify mailer library version.");
            this.server.send(email);
        }
        catch (MailException e) {
            log.error("Could not send internal email to check S/Notify mailer library version. Error message: " + e.getMessage(), (Throwable)e);
        }
        return this.appProps.getString(EProperty.MAILER_VERSION);
    }

    private Email createEmail() {
        Email email = new Email(this.server.getDefaultFrom());
        email.setSubject("S/Notify test email");
        email.setFrom(this.server.getDefaultFrom());
        email.setBody("This is a test email of S/Notify. Should you have received this, S/Notify mailer library is not properly configured or missing entirely.");
        email.addHeader("X-SNotify-Do-Not-Send", Boolean.TRUE.toString());
        return email;
    }
}

