/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.util.Option;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.IVersion;
import net.savignano.snotify.atlassian.common.NormalizedVersion;
import net.savignano.snotify.atlassian.common.update.ISnotifyUpdateManager;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.gui.MailerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PluginListener
implements IVersion {
    private static final Logger log = LoggerFactory.getLogger(PluginListener.class);
    private static final String CONFIG_FILE = "/images/tiny_logo.png";
    private static final String FULL_CAPABILITY = "Managed";
    private static final String SKIP_SIGNATURE = "SkipSig";
    @Inject
    @ComponentImport
    private PluginController controller;
    @Inject
    @ComponentImport
    private EventPublisher publisher;
    @Inject
    @ComponentImport
    private PluginLicenseEventRegistry pluginPublisher;
    @Inject
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @Inject
    @ComponentImport
    private PluginAccessor pluginAccessor;
    @Inject
    private ISnotifyAppProperties appProperties;
    @Inject
    private ISnotifyUpdateManager updateManager;

    @PostConstruct
    public void init() {
        log.debug("Initializing S/Notify License Listener.");
        log.debug("License Manager registered for plugin key: {}", (Object)this.licenseManager.getPluginKey());
        this.publisher.register((Object)this);
        this.pluginPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        log.debug("Destroying S/Notify License Listener.");
        this.publisher.unregister((Object)this);
        this.pluginPublisher.unregister((Object)this);
    }

    @Override
    public String getVersion() {
        String pluginKey = this.licenseManager.getPluginKey();
        return this.pluginAccessor.getPlugin(pluginKey).getPluginInformation().getVersion();
    }

    private boolean isRelevant(PluginEvent event) {
        return this.isRelevant(event.getPlugin().getKey());
    }

    private boolean isRelevant(String pluginKey) {
        boolean isRelevant = this.licenseManager.getPluginKey().equalsIgnoreCase(pluginKey);
        log.trace("Is event for plugin key {} relevant: ", (Object)pluginKey, (Object)isRelevant);
        return isRelevant;
    }

    @EventListener
    public void refresh(PluginRefreshedEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Refreshed Event for S/Notify detected: {}", (Object)event);
            String config = this.getConfig();
            if (this.checkSignature(config)) {
                log.info("S/Notify GUI plugin version: {}", (Object)this.getVersion());
                this.checkLite(config);
                this.checkLicense();
                this.checkUpdate();
                this.checkMailerVersion();
            }
        }
    }

    @EventListener
    public void enabled(PluginEnabledEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.info("Plugin Enabled Event for S/Notify detected: {}", (Object)event);
            this.setDisablement(false);
            String config = this.getConfig();
            if (this.checkSignature(config)) {
                log.info("S/Notify GUI plugin version: {}", (Object)this.getVersion());
                this.checkLite(config);
                this.checkLicense();
                this.checkUpdate();
                this.checkMailerVersion();
            }
        }
    }

    @EventListener
    public void disabled(PluginDisablingEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.warn("Plugin Disabling Event for S/Notify detected: {}", (Object)event);
            this.setDisablement(true);
        }
    }

    @EventListener
    public void startup(PluginFrameworkStartedEvent event) {
        log.debug("Plugin Framework Start Event for S/Notify detected: {}", (Object)event);
        String config = this.getConfig();
        if (this.checkSignature(config)) {
            log.info("S/Notify GUI plugin version: {}", (Object)this.getVersion());
            this.checkLite(config);
            this.checkLicense();
            this.checkUpdate();
            this.checkMailerVersion();
        }
    }

    @EventListener
    public void license(PluginLicenseEvent event) {
        if (this.isRelevant(event.getPluginKey())) {
            log.debug("Plugin License Event for S/Notify detected: {}", (Object)event);
            this.checkLite(this.getConfig());
            this.checkLicense();
        }
    }

    @Override
    public boolean match(String version) {
        return new NormalizedVersion(this.getVersion()).equals(new NormalizedVersion(version));
    }

    private void setDisablement(boolean disable) {
        boolean oldDisabled = this.appProperties.getBoolean(EProperty.DISABLE_SNOTIFY);
        if (oldDisabled != disable) {
            if (disable) {
                log.info("Disabling S/Notify mailer.");
            } else {
                log.info("Enabling S/Notify mailer.");
            }
            this.appProperties.setBoolean(EProperty.DISABLE_SNOTIFY, disable);
        }
    }

    private void checkLicense() {
        this.printLicense();
        boolean freeze = this.isFreezeSnotify();
        boolean oldFreeze = this.appProperties.getBoolean(EProperty.FREEZE_SNOTIFY);
        if (oldFreeze != freeze) {
            if (freeze) {
                log.info("S/Notify mailer was frozen because of an invalid license.");
            } else {
                log.info("S/Notify mailer was restored. Proper license found.");
            }
            this.appProperties.setBoolean(EProperty.FREEZE_SNOTIFY, freeze);
        }
    }

    private void checkLite(String config) {
        boolean oldLite = this.appProperties.getBoolean(EProperty.LITE_MODE);
        if (config != null) {
            if (config.contains(FULL_CAPABILITY)) {
                log.info("S/Notify Professional version recognized.");
                if (oldLite) {
                    this.appProperties.setBoolean(EProperty.LITE_MODE, false);
                }
            } else {
                log.info("S/Notify Lite version recognized.");
                if (!oldLite) {
                    this.appProperties.setBoolean(EProperty.LITE_MODE, true);
                }
            }
        }
    }

    private boolean checkSignature(String config) {
        if (config != null && config.contains(SKIP_SIGNATURE)) {
            log.debug("Skipping signature check.");
            return true;
        }
        if (SecurityUtil.checkSnotifyIntegrity()) {
            log.info("Signature of S/Notify is correct.");
            return true;
        }
        log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
        this.controller.disablePluginWithoutPersisting(this.licenseManager.getPluginKey());
        return false;
    }

    private void checkMailerVersion() {
        try {
            SMTPMailServer server = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (server == null) {
                log.warn("Can not check if correct mailer library for S/Notify is installed. Please configure an outgoing SMTP mail server, so S/Notify can automatically check if the GUI plugin and Mailer library are compatible with each other.");
                return;
            }
            String mailerVersion = new MailerVersion(server, this.appProperties).getVersion();
            log.info("S/Notify mailer library version: {}", (Object)mailerVersion);
            if (mailerVersion == null) {
                log.error("S/Notify mailer library has not been detected. Please make sure to install S/Notify mailer library to your 'lib' directory, so emails can be encrypted.");
            } else if (!this.match(mailerVersion)) {
                log.error("S/Notify mailer library has different version than S/Notify GUI plugin. Please make sure to install S/Notify mailer library in version {} to your 'lib' directory, to match the installed GUI plugin.", (Object)this.getVersion());
            }
        }
        catch (Exception e) {
            log.error("Could not check mailer library version. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkUpdate() {
        String oldVersion = this.appProperties.getString(EProperty.GUI_VERSION);
        log.debug("Last known GUI plugin version: {}", (Object)oldVersion);
        if (!this.match(oldVersion)) {
            String newVersion = this.getVersion();
            log.info("New GUI plugin version: {}", (Object)newVersion);
            this.appProperties.setString(EProperty.GUI_VERSION, newVersion);
            this.updateManager.update(oldVersion, newVersion);
        }
    }

    private boolean isFreezeSnotify() {
        Option licenseOption = this.licenseManager.getLicense();
        if (licenseOption.isDefined()) {
            PluginLicense license = (PluginLicense)licenseOption.get();
            return !license.isValid();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConfig() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(CONFIG_FILE), Constants.UTF8_CHARSET));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            log.error("Could not access config file.", (Throwable)e);
            return null;
        }
    }

    private void printLicense() {
        if (!log.isDebugEnabled()) {
            return;
        }
        Option option = this.licenseManager.getLicense();
        if (option.isDefined()) {
            PluginLicense license = (PluginLicense)option.get();
            log.debug("S/Notify license: {}", (Object)license);
            if (license.getError().isDefined()) {
                LicenseError licenseError = (LicenseError)license.getError().get();
                log.debug("S/Notify license error: {}", (Object)licenseError);
            }
        } else {
            log.debug("No license for S/Notify defined.");
        }
    }
}

