/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import java.util.ArrayList;
import java.util.List;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.gui.keysource.verification.IKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeySourceVerification
implements IKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(AKeySourceVerification.class);
    private final VerificationStatusBuilder builder;
    private final List<VerificationStatus> statusList = new ArrayList<VerificationStatus>();

    public AKeySourceVerification(ISnotifyI18n i18n) {
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
        this.builder = new VerificationStatusBuilder(i18n);
    }

    @Override
    public List<VerificationStatus> verify() {
        try {
            this.doVerify();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.verification.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.verification.exception.message", e.getClass().getSimpleName(), e.getMessage());
            this.build();
        }
        return this.getStatusList();
    }

    protected abstract void doVerify() throws Exception;

    protected void verifyKey(ISnotifyKey<?> key, ECryptographyType cryptography) {
        this.getBuilder().subTitle("net.savignano.snotify.key-verification.title", new Object[0]);
        if (key == null) {
            this.getBuilder().warning();
            this.getBuilder().message("net.savignano.snotify.key-verification.noKey." + cryptography.name() + ".message", new Object[0]);
        } else if (key.isValid()) {
            this.getBuilder().success();
            this.getBuilder().message("net.savignano.snotify.key-verification.success." + cryptography.name() + ".message", new Object[0]);
        } else {
            this.getBuilder().error();
            this.getBuilder().message("net.savignano.snotify.key-verification.failure." + cryptography.name() + ".message", this.getBuilder().getI18n().getText("net.savignano.snotify.verification." + key.getKeyPurpose().name()));
        }
        this.build();
    }

    protected void build() {
        this.getStatusList().add(this.getBuilder().build());
    }

    protected ISnotifyI18n getI18n() {
        return this.getBuilder().getI18n();
    }

    protected VerificationStatusBuilder getBuilder() {
        return this.builder;
    }

    protected List<VerificationStatus> getStatusList() {
        return this.statusList;
    }
}

