/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(LdapVerification.class);
    private final LdapConnector connector;
    private String userName;

    public LdapVerification(LdapConnector connector, ISnotifyI18n i18n) {
        super(i18n);
        if (connector == null) {
            throw new IllegalArgumentException("Connector must not be null.");
        }
        this.connector = connector;
        this.setUserName(this.userName);
        this.getBuilder().title("net.savignano.snotify.ldap-verification.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        log.debug("Using connector: {}", (Object)this.connector);
        this.canConnect();
    }

    private void canConnect() {
        try {
            log.debug("Connecting to LDAP location: {}", (Object)this.connector.getLdapUrl());
            this.connector.connect();
        }
        catch (Exception e) {
            log.debug("Could not connect to LDAP location " + this.connector.getLdapUrl() + ". Error message: " + e.getMessage(), (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.ldap-verification.canConnect.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.ldap-verification.canConnect.exception.message", this.connector.getLdapUrl(), e.getMessage());
            this.build();
            return;
        }
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.ldap-verification.canConnect.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.ldap-verification.canConnect.success.message", this.connector.getLdapUrl());
        this.build();
        try {
            this.findUser();
        }
        finally {
            this.connector.disconnect();
        }
    }

    private void findUser() {
        boolean found;
        if (this.getUserName() == null) {
            log.debug("No user was given, so can't check if user can be found in LDAP.");
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.ldap-verification.findUser.noUser.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.ldap-verification.findUser.noUser.message", new Object[0]);
            this.build();
            return;
        }
        DirContext context = this.connector.getContext();
        String userId = this.connector.getUserNameKey() + "=" + this.getUserName();
        String filter = "(" + userId + ")";
        if (this.connector.getFilter() != null) {
            filter = "(&" + filter + this.connector.getFilter() + ")";
        }
        SearchControls searchControls = new SearchControls(2, 1L, 10000, new String[0], false, false);
        try {
            log.debug("Looking up user at: {} {}", (Object)this.connector.getUserBase(), (Object)filter);
            found = context.search(this.connector.getUserBase(), filter, searchControls).hasMore();
        }
        catch (Exception e) {
            log.debug("Could not look up user " + this.getUserName() + " at LDAP location " + this.connector.getLdapUrl() + ". Error message: " + e.getMessage(), (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.ldap-verification.findUser.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.ldap-verification.findUser.exception.message", this.getUserName(), e.getMessage());
            this.build();
            return;
        }
        log.debug("Found user {}: {}", (Object)this.getUserName(), (Object)found);
        if (found) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.ldap-verification.findUser.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.ldap-verification.findUser.success.message", this.getUserName());
        } else {
            this.getBuilder().warning();
            this.getBuilder().subTitle("net.savignano.snotify.ldap-verification.findUser.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.ldap-verification.findUser.failure.message", this.getUserName());
        }
        this.build();
    }

    public LdapConnector getConnector() {
        return this.connector;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

