/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.Set;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeSignKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeKeyStoreVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeKeyStoreVerification.class);
    private static final String CRYPTOGRAPHY_SUPPORT_ERROR = "JCE cannot authenticate the provider SAVIGNANO-BC";
    private final String keyStoreType;
    private final String location;
    private final Set<String> emails = new LinkedHashSet<String>();
    private char[] keyStorePassword;
    private char[] keyPassword;
    private boolean enablePrivateKeyCheck;

    public SmimeKeyStoreVerification(String location, String keyStoreType, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("Key Store Type must not be null.");
        }
        this.location = location;
        this.keyStoreType = keyStoreType;
    }

    @Override
    protected void doVerify() throws Exception {
        if (this.isEnablePrivateKeyCheck()) {
            this.getBuilder().title("net.savignano.snotify.smime-private-keystore-verification.title", new Object[0]);
        } else {
            this.getBuilder().title("net.savignano.snotify.smime-public-keystore-verification.title", new Object[0]);
        }
        this.canReadLocation();
    }

    private void canReadLocation() {
        SecurityException e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (SecurityException e1) {
            e = e1;
            log.debug("Can not access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().status(EVerificationStatus.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Provider provider = SecurityUtil.getProvider();
        boolean outdatedJava = false;
        Exception e = null;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(this.keyStoreType, provider);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.location));){
                ks.load(in, this.getKeyStorePassword());
                log.debug("Could load key store from location: {}", (Object)this.location);
            }
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
            outdatedJava = e.getMessage().contains(CRYPTOGRAPHY_SUPPORT_ERROR);
        }
        if (e == null) {
            this.getBuilder().status(EVerificationStatus.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.loadKeyStore.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.loadKeyStore.success.message", new Object[0]);
            this.build();
            this.checkEmails(ks);
        } else if (outdatedJava) {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.loadKeyStore.cryptographySupport.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.loadKeyStore.cryptographySupport.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmails(KeyStore keyStore) {
        if (keyStore == null) {
            return;
        }
        if (this.getEmails().isEmpty()) {
            log.debug("No email address was given, so can't check if a certificate was found for it.");
            this.getBuilder().status(EVerificationStatus.INFO);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkEmail.noEmail.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkEmail.noEmail.message", new Object[0]);
            this.build();
            return;
        }
        for (String email : this.getEmails()) {
            X509Certificate cert;
            try {
                cert = SmimeUtil.getCertForEmail(keyStore, email);
            }
            catch (Exception e) {
                log.debug("Could not look up email <" + email + "> in keystore \"" + keyStore + "\".", (Throwable)e);
                this.getBuilder().status(EVerificationStatus.ERROR);
                this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkEmail.exception.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkEmail.exception.message", email, e.getClass().getSimpleName(), e.getLocalizedMessage());
                this.build();
                return;
            }
            if (cert != null) {
                log.debug("Certificate for email <{}> was found in key store.", (Object)email);
                this.getBuilder().status(EVerificationStatus.SUCCESS);
                this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkEmail.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkEmail.success.message", email);
                this.build();
                if (this.isEnablePrivateKeyCheck()) {
                    this.checkPrivateKey(keyStore, cert);
                    continue;
                }
                this.verifyKey(new SnotifySmimePublicKey(cert, email), ECryptographyType.SMIME);
                continue;
            }
            log.debug("No certificate for email <{}> was found in key store.", (Object)email);
            this.getBuilder().status(EVerificationStatus.WARNING);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkEmail.failure.message", email);
            this.build();
        }
    }

    private void checkPrivateKey(KeyStore keyStore, X509Certificate cert) {
        Key key;
        String alias;
        if (keyStore == null) {
            return;
        }
        if (this.getKeyPassword() == null) {
            log.debug("No key password was given, so can't check if it matches a private key.");
            this.getBuilder().status(EVerificationStatus.INFO);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.noPassword.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.noPassword.message", new Object[0]);
            this.build();
            return;
        }
        try {
            alias = keyStore.getCertificateAlias(cert);
            if (alias == null) {
                throw new KeyStoreException("No alias found for certificate with serial number: " + SmimeUtil.getSerialNumber(cert));
            }
        }
        catch (Exception e) {
            log.debug("Could not look up alias for cert with serial number \"" + SmimeUtil.getSerialNumber(cert) + "\" in key store \"" + keyStore + "\".", (Throwable)e);
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.aliasException.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.aliasException.message", SmimeUtil.getSerialNumber(cert), e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
            return;
        }
        try {
            key = keyStore.getKey(alias, this.getKeyPassword());
        }
        catch (UnrecoverableKeyException e) {
            log.debug("Password did not match private key for alias \"" + alias + "\" in key store \"" + keyStore + "\".", (Throwable)e);
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.passwordException.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.passwordException.message", alias);
            this.build();
            return;
        }
        catch (Exception e) {
            log.debug("Could not look up private key for alias \"" + alias + "\" in key store \"" + keyStore + "\".", (Throwable)e);
            this.getBuilder().status(EVerificationStatus.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.exception.message", alias, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
            return;
        }
        if (key != null) {
            log.debug("Found private key for alias \"{}\" in key store.", (Object)alias);
            this.getBuilder().status(EVerificationStatus.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.success.message", alias);
            this.build();
            this.verifyKey(new SnotifySmimeSignKey((PrivateKey)key, cert), ECryptographyType.SMIME);
        } else {
            log.debug("No private key for alias \"{}\" was found in key store.", (Object)alias);
            this.getBuilder().status(EVerificationStatus.WARNING);
            this.getBuilder().subTitle("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.smime-keystore-verification.checkPrivateKey.failure.message", alias);
            this.build();
        }
    }

    public Set<String> getEmails() {
        return this.emails;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isEnablePrivateKeyCheck() {
        return this.enablePrivateKeyCheck;
    }

    public void setEnablePrivateKeyCheck(boolean enablePrivateKeyCheck) {
        this.enablePrivateKeyCheck = enablePrivateKeyCheck;
    }
}

