/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import com.atlassian.velocity.htmlsafe.HtmlSafe;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import org.apache.commons.lang.StringEscapeUtils;

public class VerificationStatus {
    public EVerificationStatus status;
    public String title;
    public String message;

    public VerificationStatus() {
    }

    public VerificationStatus(EVerificationStatus status, String message, String title) {
        this.status = status;
        this.message = message;
        this.title = title;
    }

    @HtmlSafe
    public String getHtmlStatus() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("<div class=\"aui-message ");
        if (this.status == null) {
            builder.append("aui-message-generic");
        } else {
            builder.append(this.status.getHtmlMessageClass());
        }
        builder.append("\">\n");
        if (this.title != null) {
            builder.append("<p class=\"title\"><strong>");
            builder.append(StringEscapeUtils.escapeHtml((String)this.title));
            builder.append("</strong></p>\n");
        }
        if (this.message != null) {
            builder.append("<p>");
            builder.append(StringEscapeUtils.escapeHtml((String)this.message));
            builder.append("</p>\n");
        }
        builder.append("</div>");
        return builder.toString();
    }

    public String toString() {
        return "VerificationStatus [status=" + (Object)((Object)this.status) + ", title=" + this.title + ", message=" + this.message + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerificationStatus other = (VerificationStatus)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

