/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import java.util.Locale;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.NormalizedVersion;
import net.savignano.snotify.confluence.common.SnotifyAppProperties;
import net.savignano.snotify.confluence.common.SnotifyI18n;

public class SnotifyAdminSettingsAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 2369607869773471446L;
    private ISnotifyAppProperties appProps;
    private ISnotifyI18n i18n;
    private boolean showUpdated;

    public boolean hasAdminRights() {
        return ((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser());
    }

    public ISnotifyAppProperties getAppProps() {
        if (this.appProps == null) {
            this.appProps = new SnotifyAppProperties();
        }
        return this.appProps;
    }

    public ISnotifyI18n getSnotifyI18n() {
        if (this.i18n == null) {
            LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
            Locale locale = localeManager.getLocale((User)this.getAuthenticatedUser());
            this.i18n = new SnotifyI18n(this.getI18n(), locale);
        }
        return this.i18n;
    }

    public String getGetStartedLink() {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        return baseUrl + "/plugins/snotify/snotify-installation-guide.action";
    }

    public boolean isMailerLibPresent() {
        return this.getMailerVersion() != null;
    }

    public boolean isVersionMatch() {
        NormalizedVersion guiVersion = new NormalizedVersion(this.getGuiVersion());
        NormalizedVersion mailerVersion = new NormalizedVersion(this.getMailerVersion());
        return guiVersion.equals(mailerVersion);
    }

    public String getGuiVersion() {
        return this.getAppProps().getString(EProperty.GUI_VERSION);
    }

    public String getMailerVersion() {
        return this.getAppProps().getString(EProperty.MAILER_VERSION);
    }

    public boolean isDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    public boolean isFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    public boolean isLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    public boolean isShowUpdated() {
        return this.showUpdated;
    }

    public void setShowUpdated(boolean showUpdated) {
        this.showUpdated = showUpdated;
    }
}

