/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.savignano.snotify.atlassian.common.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TweakSnotifyAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = -3197109585716079423L;
    private static final Logger log = LoggerFactory.getLogger(TweakSnotifyAction.class);
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    private String errorMessage;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        return "input";
    }

    public String doAdd() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        String value = this.getCurrentRequest().getParameter(VALUE_PARAM);
        log.debug("Adding key/value pair to tweaks: {} = {}", (Object)key, (Object)value);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            log.debug("Key or Value is considered empty. Tweak will not be added.");
            return "input";
        }
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (!prop.isPresent()) {
            log.debug("Key {} does not represent a tweak.", (Object)key);
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.notAPropertyTitle", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.notAPropertyMessage", key);
            this.errorMessage = builder.build().getHtmlStatus();
            return "input";
        }
        ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), value);
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.put(key, value);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
        return "input";
    }

    public String doDelete() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        log.debug("Removing key from tweaks: {}", (Object)key);
        if (StringUtils.isBlank((CharSequence)key)) {
            log.debug("Key is considered empty. Tweak will not be removed.");
            return "input";
        }
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (prop.isPresent()) {
            this.getAppProps().setString(prop.get(), null);
        } else {
            log.debug("Key {} does not represent a tweak.", (Object)key);
        }
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.remove(key);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
        return "input";
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getUsedTweaks().entrySet();
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        if (tweakString != null) {
            for (String oneTweak : tweakString.split("\\;")) {
                String[] keyValue = oneTweak.split("\\=");
                if (keyValue.length == 2) {
                    tweaks.put(keyValue[0], keyValue[1]);
                    continue;
                }
                log.warn("Unknown key/value format ({}) detected in tweaks: {}", (Object)keyValue, (Object)tweakString);
            }
        }
        return tweaks;
    }

    private void setUsedTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
                builder.append(";");
            }
            builder.deleteCharAt(builder.lastIndexOf(";"));
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, builder.toString());
        }
    }
}

