/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.MPInteger;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Packet;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignaturePacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignatureSubpacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.TrustPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserAttributeSubpacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class PGPSignature {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int PRIMARYKEY_BINDING = 25;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    private SignaturePacket sigPck;
    private int signatureType;
    private TrustPacket trustPck;
    private PGPContentVerifier verifier;
    private byte lastb;
    private OutputStream sigOut;

    private static SignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof SignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (SignaturePacket)packet;
    }

    PGPSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this(PGPSignature.cast(pIn.readPacket()));
    }

    PGPSignature(SignaturePacket sigPacket) throws PGPException {
        this.sigPck = sigPacket;
        this.signatureType = this.sigPck.getSignatureType();
        this.trustPck = null;
    }

    PGPSignature(SignaturePacket sigPacket, TrustPacket trustPacket) throws PGPException {
        this(sigPacket);
        this.trustPck = trustPacket;
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public boolean isCertification() {
        return PGPSignature.isCertification(this.getSignatureType());
    }

    public void init(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey pubKey) throws PGPException {
        PGPContentVerifierBuilder verifierBuilder = verifierBuilderProvider.get(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm());
        this.verifier = verifierBuilder.build(pubKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public void update(byte b) {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte[] bytes, int off, int length) {
        if (this.signatureType == 1) {
            int finish = off + length;
            for (int i = off; i != finish; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.blockUpdate(bytes, off, length);
        }
    }

    private void byteUpdate(byte b) {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    private void blockUpdate(byte[] block, int off, int len) {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    public boolean verify() throws PGPException {
        try {
            this.sigOut.write(this.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPException(e.getMessage(), e);
        }
        return this.verifier.verify(this.getSignature());
    }

    private void updateWithIdData(int header, byte[] idBytes) {
        this.update((byte)header);
        this.update((byte)(idBytes.length >> 24));
        this.update((byte)(idBytes.length >> 16));
        this.update((byte)(idBytes.length >> 8));
        this.update((byte)idBytes.length);
        this.update(idBytes);
    }

    private void updateWithPublicKey(PGPPublicKey key) throws PGPException {
        byte[] keyBytes = this.getEncodedPublicKey(key);
        this.update((byte)-103);
        this.update((byte)(keyBytes.length >> 8));
        this.update((byte)keyBytes.length);
        this.update(keyBytes);
    }

    public boolean verifyCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(key);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            UserAttributeSubpacket[] packets = userAttributes.toSubpacketArray();
            for (int i = 0; i != packets.length; ++i) {
                packets[i].encode(bOut);
            }
            this.updateWithIdData(209, bOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("cannot encode subpacket array", e);
        }
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(String id, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(key);
        this.updateWithIdData(180, Strings.toUTF8ByteArray(id));
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(byte[] rawID, PGPPublicKey key) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(key);
        this.updateWithIdData(180, rawID);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    private void addTrailer() {
        try {
            this.sigOut.write(this.sigPck.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    public boolean verifyCertification(PGPPublicKey pubKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (this.getSignatureType() != 32 && this.getSignatureType() != 40 && this.getSignatureType() != 31) {
            throw new PGPException("signature is not a key signature");
        }
        this.updateWithPublicKey(pubKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public boolean hasSubpackets() {
        return this.sigPck.getHashedSubPackets() != null || this.sigPck.getUnhashedSubPackets() != null;
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] pcks) {
        if (pcks != null) {
            return new PGPSignatureSubpacketVector(pcks);
        }
        return null;
    }

    public byte[] getSignature() throws PGPException {
        byte[] signature;
        MPInteger[] sigValues = this.sigPck.getSignature();
        if (sigValues != null) {
            if (sigValues.length == 1) {
                signature = BigIntegers.asUnsignedByteArray(sigValues[0].getValue());
            } else if (this.getKeyAlgorithm() == 22) {
                signature = new byte[64];
                byte[] a = BigIntegers.asUnsignedByteArray(sigValues[0].getValue());
                byte[] b = BigIntegers.asUnsignedByteArray(sigValues[1].getValue());
                System.arraycopy(a, 0, signature, 32 - a.length, a.length);
                System.arraycopy(b, 0, signature, 64 - b.length, b.length);
            } else {
                try {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add(new ASN1Integer(sigValues[0].getValue()));
                    v.add(new ASN1Integer(sigValues[1].getValue()));
                    signature = new DERSequence(v).getEncoded();
                }
                catch (IOException e) {
                    throw new PGPException("exception encoding DSA sig.", e);
                }
            }
        } else {
            signature = this.sigPck.getSignatureBytes();
        }
        return signature;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.sigPck);
        if (!forTransfer && this.trustPck != null) {
            out.writePacket(this.trustPck);
        }
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pubKey) throws PGPException {
        byte[] keyBytes;
        try {
            keyBytes = pubKey.publicPk.getEncodedContents();
        }
        catch (IOException e) {
            throw new PGPException("exception preparing key.", e);
        }
        return keyBytes;
    }

    public static boolean isCertification(int signatureType) {
        return 16 == signatureType || 17 == signatureType || 18 == signatureType || 19 == signatureType;
    }
}

